/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.util.concurrent.Future;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class CheckUtil {
    private static final int SLEEP_FOR = 200;
    private static final int TIMEOUT = 30;

    private CheckUtil() {
    }

    public static <T extends Future<?>> void waitFutureSuccess(T future) {
        CheckUtil.waitFutureSuccess(future, 200L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    static <T extends Future<?>> void waitFutureSuccess(T future, long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        future.addListener(future1 -> latch.countDown());
        Uninterruptibles.awaitUninterruptibly(latch, timeout, unit);
        Verify.verify(future.isSuccess());
    }

    public static <R, T extends DataObject> R readDataOperational(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function) throws InterruptedException, ExecutionException {
        return CheckUtil.readDataOperational(dataBroker, iid, function, 30);
    }

    @VisibleForTesting
    static <R, T extends DataObject> R readDataOperational(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws InterruptedException, ExecutionException {
        return CheckUtil.readData(dataBroker, LogicalDatastoreType.OPERATIONAL, iid, function, timeout);
    }

    public static <R, T extends DataObject> R readDataConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function) throws InterruptedException, ExecutionException {
        return CheckUtil.readDataConfiguration(dataBroker, iid, function, 30);
    }

    @VisibleForTesting
    static <R, T extends DataObject> R readDataConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws InterruptedException, ExecutionException {
        return CheckUtil.readData(dataBroker, LogicalDatastoreType.CONFIGURATION, iid, function, timeout);
    }

    private static <R, T extends DataObject> R readData(DataBroker dataBroker, LogicalDatastoreType ldt, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws InterruptedException, ExecutionException {
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        do {
            try (ReadTransaction tx = dataBroker.newReadOnlyTransaction();){
                R r;
                Optional data = (Optional)tx.read(ldt, iid).get();
                if (!data.isPresent()) continue;
                try {
                    r = function.apply((DataObject)data.get());
                }
                catch (AssertionError e) {
                    lastError = e;
                    Uninterruptibles.sleepUninterruptibly(200L, TimeUnit.MILLISECONDS);
                    continue;
                }
                return r;
            }
        } while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout);
        throw lastError;
    }

    public static <T extends DataObject> T checkPresentOperational(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        return (T)CheckUtil.readData(dataBroker, LogicalDatastoreType.OPERATIONAL, iid, bgpRib -> bgpRib, 30);
    }

    public static <T extends DataObject> T checkPresentConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        return (T)CheckUtil.readData(dataBroker, LogicalDatastoreType.CONFIGURATION, iid, bgpRib -> bgpRib, 30);
    }

    public static <T extends DataObject> void checkNotPresentOperational(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        CheckUtil.checkNotPresent(dataBroker, LogicalDatastoreType.OPERATIONAL, iid);
    }

    public static <T extends DataObject> void checkNotPresentConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        CheckUtil.checkNotPresent(dataBroker, LogicalDatastoreType.CONFIGURATION, iid);
    }

    private static <T extends DataObject> void checkNotPresent(DataBroker dataBroker, LogicalDatastoreType ldt, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= 10L) {
            ReadTransaction tx = dataBroker.newReadOnlyTransaction();
            Optional data = (Optional)tx.read(ldt, iid).get();
            try {
                assert (!data.isPresent());
                if (tx != null) {
                    tx.close();
                }
                return;
            }
            catch (AssertionError e) {
                try {
                    lastError = e;
                    Uninterruptibles.sleepUninterruptibly(10L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (tx == null) continue;
                    tx.close();
                }
            }
        }
        throw lastError;
    }

    public static void checkEquals(CheckEquals function) throws Exception {
        CheckUtil.checkEquals(function, 30);
    }

    public static void checkEquals(CheckEquals function, int timeout) throws Exception {
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout) {
            try {
                function.check();
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                Uninterruptibles.sleepUninterruptibly(10L, TimeUnit.MILLISECONDS);
            }
        }
        throw lastError;
    }

    public static void checkReceivedMessages(ListenerCheck listener, int numberOfMessages) {
        CheckUtil.checkReceivedMessages(listener, numberOfMessages, 30);
    }

    @VisibleForTesting
    static void checkReceivedMessages(ListenerCheck listener, int numberOfMessages, int timeout) {
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout) {
            if (listener.getListMessageSize() != numberOfMessages) {
                Uninterruptibles.sleepUninterruptibly(200L, TimeUnit.MILLISECONDS);
                continue;
            }
            return;
        }
        throw new AssertionError((Object)("Expected " + numberOfMessages + " but received " + listener.getListMessageSize()));
    }

    @FunctionalInterface
    public static interface CheckEquals {
        public void check() throws ExecutionException, InterruptedException;
    }

    public static interface ListenerCheck {
        public int getListMessageSize();
    }
}

