/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;

public final class Ipv4Util {
    public static final int IP4_LENGTH = 4;
    public static final int IP4_BITS_LENGTH = 32;
    static final int PREFIX_BYTE_LENGTH = 5;
    private static final Ipv4Prefix EMPTY_PREFIX = new Ipv4Prefix("0.0.0.0/0");

    private Ipv4Util() {
    }

    public static Ipv4AddressNoZone addressForByteBuf(ByteBuf buffer) {
        return (Ipv4AddressNoZone)IetfInetUtil.INSTANCE.ipv4AddressNoZoneFor(ByteArray.readBytes(buffer, 4));
    }

    public static ByteBuf byteBufForAddress(Ipv4AddressNoZone ipAddress) {
        return Unpooled.wrappedBuffer(Ipv4Util.bytesForAddress(ipAddress));
    }

    public static byte[] bytesForAddress(Ipv4AddressNoZone address) {
        return IetfInetUtil.INSTANCE.ipv4AddressNoZoneBytes(address);
    }

    public static int prefixBitsToBytes(int bits) {
        if (bits % 8 != 0) {
            return bits / 8 + 1;
        }
        return bits / 8;
    }

    public static int getPrefixLengthBytes(String prefix) {
        return Ipv4Util.prefixBitsToBytes(Ipv4Util.getPrefixLength(prefix));
    }

    public static byte[] bytesForPrefix(Ipv4Prefix prefix) {
        return IetfInetUtil.INSTANCE.ipv4PrefixToBytes(prefix);
    }

    public static Ipv4Prefix prefixForBytes(byte[] bytes, int length) {
        Preconditions.checkArgument(length <= bytes.length * 8);
        byte[] tmp = bytes.length != 4 ? Arrays.copyOfRange(bytes, 0, 4) : bytes;
        return (Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixFor(tmp, length);
    }

    public static Ipv4Prefix prefixForByteBuf(ByteBuf buf) {
        return Ipv4Util.prefixForByteBuf(buf, buf.readUnsignedByte());
    }

    public static Ipv4Prefix prefixForByteBuf(ByteBuf buf, int prefixLength) {
        int size = prefixLength / 8 + (prefixLength % 8 == 0 ? 0 : 1);
        int readable = buf.readableBytes();
        Preconditions.checkArgument(size <= readable, "Illegal length of IP prefix: %s/%s", size, readable);
        byte[] bytes = new byte[4];
        buf.readBytes(bytes, 0, size);
        return (Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixFor(bytes, prefixLength);
    }

    public static List<Ipv4Prefix> prefixListForBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Ipv4Prefix> list = new ArrayList<Ipv4Prefix>();
        int byteOffset = 0;
        while (byteOffset < bytes.length) {
            int bitLength = Byte.toUnsignedInt(bytes[byteOffset]);
            ++byteOffset;
            if (bitLength == 0) {
                list.add(EMPTY_PREFIX);
                continue;
            }
            list.add((Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixForShort(bytes, byteOffset, bitLength));
            byteOffset += bitLength / 8;
            if (bitLength % 8 == 0) continue;
            ++byteOffset;
        }
        return list;
    }

    protected static int getPrefixLength(String prefixValue) {
        int sep = prefixValue.indexOf(47);
        return Integer.parseInt(prefixValue.substring(sep + 1, prefixValue.length()));
    }

    public static IpAddressNoZone getIpAddress(InetAddress inetAddress) {
        return (IpAddressNoZone)IetfInetUtil.INSTANCE.ipAddressNoZoneFor(inetAddress);
    }

    public static InetSocketAddress toInetSocketAddress(IpAddressNoZone ipAddress, PortNumber port) {
        String ipString = Ipv4Util.toStringIP(ipAddress);
        return new InetSocketAddress(InetAddresses.forString(ipString), port.getValue().toJava());
    }

    public static String incrementIpv4Address(String ipv4Address) {
        return InetAddresses.increment(InetAddresses.forString(ipv4Address)).getHostAddress();
    }

    public static Ipv4AddressNoZone incrementIpv4Address(Ipv4AddressNoZone ipv4Address) {
        return new Ipv4AddressNoZone(Ipv4Util.incrementIpv4Address(ipv4Address.getValue()));
    }

    public static Ipv4Prefix incrementIpv4Prefix(Ipv4Prefix ipv4Prefix) {
        Map.Entry splitIpv4Prefix = IetfInetUtil.INSTANCE.splitIpv4PrefixNoZone(ipv4Prefix);
        return (Ipv4Prefix)IetfInetUtil.INSTANCE.ipv4PrefixFor(Ipv4Util.incrementIpv4Address((Ipv4AddressNoZone)splitIpv4Prefix.getKey()), (int)splitIpv4Prefix.getValue());
    }

    public static String toStringIP(IpAddressNoZone ipAddress) {
        if (ipAddress.getIpv4AddressNoZone() != null) {
            return ipAddress.getIpv4AddressNoZone().getValue();
        }
        return ipAddress.getIpv6AddressNoZone().getValue();
    }

    public static void writeIpv4Address(Ipv4AddressNoZone ipv4Address, ByteBuf output) {
        if (ipv4Address != null) {
            output.writeBytes(IetfInetUtil.INSTANCE.ipv4AddressNoZoneBytes(ipv4Address));
        } else {
            output.writeInt(0);
        }
    }

    public static void writeIpv4Prefix(Ipv4Prefix ipv4Prefix, ByteBuf output) {
        if (ipv4Prefix != null) {
            output.writeBytes(Ipv4Util.bytesForPrefix(ipv4Prefix));
        } else {
            output.writeZero(5);
        }
    }

    public static void writeMinimalPrefix(Ipv4Prefix ipv4Prefix, ByteBuf output) {
        byte[] bytes = IetfInetUtil.INSTANCE.ipv4PrefixToBytes(ipv4Prefix);
        Ipv4Util.writeMinimalPrefix(output, bytes, bytes[4]);
    }

    static void writeMinimalPrefix(ByteBuf output, byte[] bytes, byte prefixBits) {
        output.writeByte(prefixBits);
        output.writeBytes(bytes, 0, Ipv4Util.prefixBitsToBytes(Byte.toUnsignedInt(prefixBits)));
    }
}

