/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;

public final class Ipv6Util {
    public static final int IPV6_LENGTH = 16;
    public static final int IPV6_BITS_LENGTH = 128;
    static final int PREFIX_BYTE_LENGTH = 17;
    private static final Ipv6Prefix EMPTY_PREFIX = new Ipv6Prefix("::/0");

    private Ipv6Util() {
    }

    public static Ipv6AddressNoZone getFullForm(Ipv6AddressNoZone ip) {
        return new Ipv6AddressNoZone(InetAddresses.forString(ip.getValue()).getHostAddress());
    }

    public static Ipv6AddressNoZone addressForByteBuf(ByteBuf buffer) {
        return (Ipv6AddressNoZone)IetfInetUtil.INSTANCE.ipv6AddressNoZoneFor(ByteArray.readBytes(buffer, 16));
    }

    public static ByteBuf byteBufForAddress(Ipv6AddressNoZone ipAddress) {
        return Unpooled.wrappedBuffer(Ipv6Util.bytesForAddress(ipAddress));
    }

    public static byte[] bytesForAddress(Ipv6AddressNoZone address) {
        return IetfInetUtil.INSTANCE.ipv6AddressNoZoneBytes(address);
    }

    public static byte[] bytesForPrefix(Ipv6Prefix prefix) {
        return IetfInetUtil.INSTANCE.ipv6PrefixToBytes(prefix);
    }

    public static Ipv6Prefix prefixForBytes(byte[] bytes, int length) {
        Preconditions.checkArgument(length <= bytes.length * 8);
        byte[] tmp = bytes.length != 16 ? Arrays.copyOfRange(bytes, 0, 16) : bytes;
        return (Ipv6Prefix)IetfInetUtil.INSTANCE.ipv6PrefixFor(tmp, length);
    }

    public static Ipv6Prefix prefixForByteBuf(ByteBuf buf) {
        short prefixLength = buf.readUnsignedByte();
        int size = prefixLength / 8 + (prefixLength % 8 == 0 ? 0 : 1);
        int readable = buf.readableBytes();
        Preconditions.checkArgument(size <= readable, "Illegal length of IP prefix: %s/%s", size, readable);
        byte[] bytes = new byte[16];
        buf.readBytes(bytes, 0, size);
        return (Ipv6Prefix)IetfInetUtil.INSTANCE.ipv6PrefixFor(bytes, (int)prefixLength);
    }

    public static List<Ipv6Prefix> prefixListForBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Ipv6Prefix> list = new ArrayList<Ipv6Prefix>();
        int byteOffset = 0;
        while (byteOffset < bytes.length) {
            int bitLength = Byte.toUnsignedInt(bytes[byteOffset]);
            ++byteOffset;
            if (bitLength == 0) {
                list.add(EMPTY_PREFIX);
                continue;
            }
            list.add((Ipv6Prefix)IetfInetUtil.INSTANCE.ipv6PrefixForShort(bytes, byteOffset, bitLength));
            byteOffset += bitLength / 8;
            if (bitLength % 8 == 0) continue;
            ++byteOffset;
        }
        return list;
    }

    public static void writeIpv6Address(Ipv6AddressNoZone ipv6Address, ByteBuf output) {
        if (ipv6Address != null) {
            output.writeBytes(IetfInetUtil.INSTANCE.ipv6AddressNoZoneBytes(ipv6Address));
        } else {
            output.writeZero(16);
        }
    }

    public static void writeIpv6Prefix(Ipv6Prefix ipv6Prefix, ByteBuf output) {
        if (ipv6Prefix != null) {
            output.writeBytes(Ipv6Util.bytesForPrefix(ipv6Prefix));
        } else {
            output.writeZero(17);
        }
    }

    public static void writeMinimalPrefix(Ipv6Prefix ipv6Prefix, ByteBuf output) {
        byte[] bytes = IetfInetUtil.INSTANCE.ipv6PrefixToBytes(ipv6Prefix);
        Ipv4Util.writeMinimalPrefix(output, bytes, bytes[16]);
    }
}

