/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.MplsLabel;
import org.opendaylight.yangtools.yang.common.Uint32;

public final class MplsLabelUtil {
    private static final int LABEL_OFFSET = 4;
    private static final byte BOTTOM_LABEL_BIT = 1;

    private MplsLabelUtil() {
    }

    public static MplsLabel mplsLabelForByteBuf(ByteBuf buffer) {
        return new MplsLabel(Uint32.valueOf(buffer.readUnsignedMedium() >> 4));
    }

    public static ByteBuf byteBufForMplsLabel(MplsLabel label) {
        return Unpooled.copyMedium(MplsLabelUtil.intForMplsLabel(label));
    }

    public static ByteBuf byteBufForMplsLabelWithBottomBit(MplsLabel label) {
        return Unpooled.copyMedium(MplsLabelUtil.intForMplsLabelWithBottomBit(label));
    }

    public static int intForMplsLabel(MplsLabel label) {
        return label.getValue().intValue() << 4;
    }

    private static int intForMplsLabelWithBottomBit(MplsLabel label) {
        int value = MplsLabelUtil.intForMplsLabel(label);
        return MplsLabelUtil.setBottomBit(value);
    }

    private static int setBottomBit(int value) {
        return value | 1;
    }

    public static boolean getBottomBit(ByteBuf slice) {
        return (slice.getUnsignedMedium(slice.readerIndex()) & 1) == 1;
    }
}

