/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class DomainName
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -7890312374818160504L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)$");
    private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
    private static final String regexes = "((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.";
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1 && length <= 253) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..253]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public DomainName(String _value) {
        if (_value != null) {
            DomainName.check_valueLength(_value);
        }
        CodeHelpers.requireValue(_value);
        CodeHelpers.checkPattern(_value, patterns, regexes);
        this._value = _value;
    }

    public DomainName(DomainName source) {
        this._value = source._value;
    }

    public static DomainName getDefaultInstance(String defaultValue) {
        return new DomainName(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DomainName)) {
            return false;
        }
        DomainName other = (DomainName)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(DomainName.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

