/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.DomainName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Host
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -2403943164556299989L;
    private final IpAddress _ipAddress;
    private final DomainName _domainName;

    public Host(IpAddress _ipAddress) {
        this._ipAddress = _ipAddress;
        this._domainName = null;
    }

    public Host(DomainName _domainName) {
        this._domainName = _domainName;
        this._ipAddress = null;
    }

    public Host(Host source) {
        this._ipAddress = source._ipAddress;
        this._domainName = source._domainName;
    }

    public String stringValue() {
        if (this._ipAddress != null) {
            return this._ipAddress.stringValue();
        }
        if (this._domainName != null) {
            return this._domainName.getValue().toString();
        }
        throw new IllegalStateException("No value assinged");
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public DomainName getDomainName() {
        return this._domainName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._ipAddress);
        result = 31 * result + Objects.hashCode(this._domainName);
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        if (!Objects.equals(this._ipAddress, other._ipAddress)) {
            return false;
        }
        return Objects.equals(this._domainName, other._domainName);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Host.class);
        CodeHelpers.appendValue(helper, "_ipAddress", this._ipAddress);
        CodeHelpers.appendValue(helper, "_domainName", this._domainName);
        return helper.toString();
    }
}

