/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;

public class IpAddressNoZoneBuilder {
    private static final Pattern IPV4_NO_ZONE_PATTERN = Pattern.compile("[0-9\\.]*");
    private static final Pattern IPV6_NO_ZONE_PATTERN1 = Pattern.compile("[0-9a-fA-F:\\.]*");

    public static IpAddressNoZone getDefaultInstance(String defaultValue) {
        if (IPV4_NO_ZONE_PATTERN.matcher(defaultValue).matches()) {
            return new IpAddressNoZone(new Ipv4AddressNoZone(defaultValue));
        }
        if (IPV6_NO_ZONE_PATTERN1.matcher(defaultValue).matches()) {
            return new IpAddressNoZone(new Ipv6AddressNoZone(defaultValue));
        }
        throw new IllegalArgumentException("Cannot create IpAddress from " + defaultValue);
    }
}

