/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class PcepDispatcherConfigBuilder
implements Builder<PcepDispatcherConfig> {
    private Uint16 _maxUnknownMessages;
    private Tls _tls;
    Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> augmentation = Collections.emptyMap();

    public PcepDispatcherConfigBuilder() {
    }

    public PcepDispatcherConfigBuilder(PcepDispatcherConfig base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._maxUnknownMessages = base.getMaxUnknownMessages();
        this._tls = base.getTls();
    }

    public Uint16 getMaxUnknownMessages() {
        return this._maxUnknownMessages;
    }

    public Tls getTls() {
        return this._tls;
    }

    public <E$$ extends Augmentation<PcepDispatcherConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaxUnknownMessagesRange(int value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..65535]]", value);
    }

    public PcepDispatcherConfigBuilder setMaxUnknownMessages(Uint16 value) {
        if (value != null) {
            PcepDispatcherConfigBuilder.checkMaxUnknownMessagesRange(value.intValue());
        }
        this._maxUnknownMessages = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public PcepDispatcherConfigBuilder setMaxUnknownMessages(Integer value) {
        return this.setMaxUnknownMessages(CodeHelpers.compatUint(value));
    }

    public PcepDispatcherConfigBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }

    public PcepDispatcherConfigBuilder addAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType, Augmentation<PcepDispatcherConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepDispatcherConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepDispatcherConfig build() {
        return new PcepDispatcherConfigImpl(this);
    }

    private static final class PcepDispatcherConfigImpl
    extends AbstractAugmentable<PcepDispatcherConfig>
    implements PcepDispatcherConfig {
        private final Uint16 _maxUnknownMessages;
        private final Tls _tls;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcepDispatcherConfigImpl(PcepDispatcherConfigBuilder base) {
            super(base.augmentation);
            this._maxUnknownMessages = base.getMaxUnknownMessages();
            this._tls = base.getTls();
        }

        @Override
        public Uint16 getMaxUnknownMessages() {
            return this._maxUnknownMessages;
        }

        @Override
        public Tls getTls() {
            return this._tls;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxUnknownMessages);
            result = 31 * result + Objects.hashCode(this._tls);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepDispatcherConfig.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            PcepDispatcherConfig other = (PcepDispatcherConfig)obj;
            if (!Objects.equals(this._maxUnknownMessages, other.getMaxUnknownMessages())) {
                return false;
            }
            if (!Objects.equals(this._tls, other.getTls())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepDispatcherConfigImpl otherImpl = (PcepDispatcherConfigImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepDispatcherConfig");
            CodeHelpers.appendValue(helper, "_maxUnknownMessages", this._maxUnknownMessages);
            CodeHelpers.appendValue(helper, "_tls", this._tls);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

