/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class PcepSessionConfigBuilder
implements Builder<PcepSessionConfig> {
    private Uint16 _deadTimerValue;
    private Uint16 _keepAliveTimerValue;
    Map<Class<? extends Augmentation<PcepSessionConfig>>, Augmentation<PcepSessionConfig>> augmentation = Collections.emptyMap();

    public PcepSessionConfigBuilder() {
    }

    public PcepSessionConfigBuilder(PcepSessionConfig base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
    }

    public Uint16 getDeadTimerValue() {
        return this._deadTimerValue;
    }

    public Uint16 getKeepAliveTimerValue() {
        return this._keepAliveTimerValue;
    }

    public <E$$ extends Augmentation<PcepSessionConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PcepSessionConfigBuilder setDeadTimerValue(Uint16 value) {
        this._deadTimerValue = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public PcepSessionConfigBuilder setDeadTimerValue(Integer value) {
        return this.setDeadTimerValue(CodeHelpers.compatUint(value));
    }

    public PcepSessionConfigBuilder setKeepAliveTimerValue(Uint16 value) {
        this._keepAliveTimerValue = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public PcepSessionConfigBuilder setKeepAliveTimerValue(Integer value) {
        return this.setKeepAliveTimerValue(CodeHelpers.compatUint(value));
    }

    public PcepSessionConfigBuilder addAugmentation(Class<? extends Augmentation<PcepSessionConfig>> augmentationType, Augmentation<PcepSessionConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionConfig>>, Augmentation<PcepSessionConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepSessionConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepSessionConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepSessionConfig build() {
        return new PcepSessionConfigImpl(this);
    }

    private static final class PcepSessionConfigImpl
    extends AbstractAugmentable<PcepSessionConfig>
    implements PcepSessionConfig {
        private final Uint16 _deadTimerValue;
        private final Uint16 _keepAliveTimerValue;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcepSessionConfigImpl(PcepSessionConfigBuilder base) {
            super(base.augmentation);
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        }

        @Override
        public Uint16 getDeadTimerValue() {
            return this._deadTimerValue;
        }

        @Override
        public Uint16 getKeepAliveTimerValue() {
            return this._keepAliveTimerValue;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadTimerValue);
            result = 31 * result + Objects.hashCode(this._keepAliveTimerValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepSessionConfig.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            PcepSessionConfig other = (PcepSessionConfig)obj;
            if (!Objects.equals(this._deadTimerValue, other.getDeadTimerValue())) {
                return false;
            }
            if (!Objects.equals(this._keepAliveTimerValue, other.getKeepAliveTimerValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepSessionConfigImpl otherImpl = (PcepSessionConfigImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepSessionConfig");
            CodeHelpers.appendValue(helper, "_deadTimerValue", this._deadTimerValue);
            CodeHelpers.appendValue(helper, "_keepAliveTimerValue", this._keepAliveTimerValue);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

