/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Rfc2385Key
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 4716367644152991000L;
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1 && length <= 80) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..80]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public Rfc2385Key(String _value) {
        if (_value != null) {
            Rfc2385Key.check_valueLength(_value);
        }
        CodeHelpers.requireValue(_value);
        this._value = _value;
    }

    public Rfc2385Key(Rfc2385Key source) {
        this._value = source._value;
    }

    public static Rfc2385Key getDefaultInstance(String defaultValue) {
        return new Rfc2385Key(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rfc2385Key)) {
            return false;
        }
        Rfc2385Key other = (Rfc2385Key)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Rfc2385Key.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

