/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Float32
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -9133028837184821048L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[4..4]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public Float32(byte[] _value) {
        if (_value != null) {
            Float32.check_valueLength(_value);
        }
        CodeHelpers.requireValue(_value);
        this._value = (byte[])_value.clone();
    }

    public Float32(Float32 source) {
        this._value = source._value;
    }

    public static Float32 getDefaultInstance(String defaultValue) {
        return new Float32(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Float32)) {
            return false;
        }
        Float32 other = (Float32)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Float32.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

