/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Float64
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -9128437988250207037L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 8) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[8..8]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public Float64(byte[] _value) {
        if (_value != null) {
            Float64.check_valueLength(_value);
        }
        CodeHelpers.requireValue(_value);
        this._value = (byte[])_value.clone();
    }

    public Float64(Float64 source) {
        this._value = source._value;
    }

    public static Float64 getDefaultInstance(String defaultValue) {
        return new Float64(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Float64)) {
            return false;
        }
        Float64 other = (Float64)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Float64.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

