/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class SrpIdNumber
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -7985654367172602048L;
    private final Uint32 _value;

    private static void check_valueRange(long value) {
        if (value <= 0xFFFFFFFEL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967294]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public SrpIdNumber(Uint32 _value) {
        if (_value != null) {
            SrpIdNumber.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue(_value);
        this._value = _value;
    }

    @Deprecated(forRemoval=true)
    public SrpIdNumber(Long _value) {
        this(CodeHelpers.compatUint(_value));
    }

    public SrpIdNumber(SrpIdNumber source) {
        this._value = source._value;
    }

    public static SrpIdNumber getDefaultInstance(String defaultValue) {
        return new SrpIdNumber(Uint32.valueOf(defaultValue));
    }

    public Uint32 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SrpIdNumber)) {
            return false;
        }
        SrpIdNumber other = (SrpIdNumber)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SrpIdNumber.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

