/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class SymbolicPathName
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -5688380084332043475L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length >= 1 && length <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..65535]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public SymbolicPathName(byte[] _value) {
        if (_value != null) {
            SymbolicPathName.check_valueLength(_value);
        }
        CodeHelpers.requireValue(_value);
        this._value = (byte[])_value.clone();
    }

    public SymbolicPathName(SymbolicPathName source) {
        this._value = source._value;
    }

    public static SymbolicPathName getDefaultInstance(String defaultValue) {
        return new SymbolicPathName(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SymbolicPathName)) {
            return false;
        }
        SymbolicPathName other = (SymbolicPathName)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SymbolicPathName.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

