/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ErrorMessagesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ReplyTimeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class MessagesBuilder
implements Builder<Messages> {
    private ErrorMessages _errorMessages;
    private Uint32 _lastSentMsgTimestamp;
    private Uint32 _receivedMsgCount;
    private ReplyTime _replyTime;
    private Uint32 _sentMsgCount;
    private Uint16 _unknownMsgReceived;
    Map<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> augmentation = Collections.emptyMap();

    public MessagesBuilder() {
    }

    public MessagesBuilder(ReplyTimeGrouping arg) {
        this._replyTime = arg.getReplyTime();
    }

    public MessagesBuilder(ErrorMessagesGrouping arg) {
        this._errorMessages = arg.getErrorMessages();
    }

    public MessagesBuilder(Messages base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._errorMessages = base.getErrorMessages();
        this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
        this._receivedMsgCount = base.getReceivedMsgCount();
        this._replyTime = base.getReplyTime();
        this._sentMsgCount = base.getSentMsgCount();
        this._unknownMsgReceived = base.getUnknownMsgReceived();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ReplyTimeGrouping) {
            this._replyTime = ((ReplyTimeGrouping)arg).getReplyTime();
            isValidArg = true;
        }
        if (arg instanceof ErrorMessagesGrouping) {
            this._errorMessages = ((ErrorMessagesGrouping)arg).getErrorMessages();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ReplyTimeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ErrorMessagesGrouping]");
    }

    public ErrorMessages getErrorMessages() {
        return this._errorMessages;
    }

    public Uint32 getLastSentMsgTimestamp() {
        return this._lastSentMsgTimestamp;
    }

    public Uint32 getReceivedMsgCount() {
        return this._receivedMsgCount;
    }

    public ReplyTime getReplyTime() {
        return this._replyTime;
    }

    public Uint32 getSentMsgCount() {
        return this._sentMsgCount;
    }

    public Uint16 getUnknownMsgReceived() {
        return this._unknownMsgReceived;
    }

    public <E$$ extends Augmentation<Messages>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public MessagesBuilder setErrorMessages(ErrorMessages value) {
        this._errorMessages = value;
        return this;
    }

    public MessagesBuilder setLastSentMsgTimestamp(Uint32 value) {
        this._lastSentMsgTimestamp = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public MessagesBuilder setLastSentMsgTimestamp(Long value) {
        return this.setLastSentMsgTimestamp(CodeHelpers.compatUint(value));
    }

    public MessagesBuilder setReceivedMsgCount(Uint32 value) {
        this._receivedMsgCount = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public MessagesBuilder setReceivedMsgCount(Long value) {
        return this.setReceivedMsgCount(CodeHelpers.compatUint(value));
    }

    public MessagesBuilder setReplyTime(ReplyTime value) {
        this._replyTime = value;
        return this;
    }

    public MessagesBuilder setSentMsgCount(Uint32 value) {
        this._sentMsgCount = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public MessagesBuilder setSentMsgCount(Long value) {
        return this.setSentMsgCount(CodeHelpers.compatUint(value));
    }

    public MessagesBuilder setUnknownMsgReceived(Uint16 value) {
        this._unknownMsgReceived = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public MessagesBuilder setUnknownMsgReceived(Integer value) {
        return this.setUnknownMsgReceived(CodeHelpers.compatUint(value));
    }

    public MessagesBuilder addAugmentation(Class<? extends Augmentation<Messages>> augmentationType, Augmentation<Messages> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Messages>>, Augmentation<Messages>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MessagesBuilder removeAugmentation(Class<? extends Augmentation<Messages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Messages build() {
        return new MessagesImpl(this);
    }

    private static final class MessagesImpl
    extends AbstractAugmentable<Messages>
    implements Messages {
        private final ErrorMessages _errorMessages;
        private final Uint32 _lastSentMsgTimestamp;
        private final Uint32 _receivedMsgCount;
        private final ReplyTime _replyTime;
        private final Uint32 _sentMsgCount;
        private final Uint16 _unknownMsgReceived;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MessagesImpl(MessagesBuilder base) {
            super(base.augmentation);
            this._errorMessages = base.getErrorMessages();
            this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
            this._receivedMsgCount = base.getReceivedMsgCount();
            this._replyTime = base.getReplyTime();
            this._sentMsgCount = base.getSentMsgCount();
            this._unknownMsgReceived = base.getUnknownMsgReceived();
        }

        @Override
        public ErrorMessages getErrorMessages() {
            return this._errorMessages;
        }

        @Override
        public Uint32 getLastSentMsgTimestamp() {
            return this._lastSentMsgTimestamp;
        }

        @Override
        public Uint32 getReceivedMsgCount() {
            return this._receivedMsgCount;
        }

        @Override
        public ReplyTime getReplyTime() {
            return this._replyTime;
        }

        @Override
        public Uint32 getSentMsgCount() {
            return this._sentMsgCount;
        }

        @Override
        public Uint16 getUnknownMsgReceived() {
            return this._unknownMsgReceived;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._errorMessages);
            result = 31 * result + Objects.hashCode(this._lastSentMsgTimestamp);
            result = 31 * result + Objects.hashCode(this._receivedMsgCount);
            result = 31 * result + Objects.hashCode(this._replyTime);
            result = 31 * result + Objects.hashCode(this._sentMsgCount);
            result = 31 * result + Objects.hashCode(this._unknownMsgReceived);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Messages.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Messages other = (Messages)obj;
            if (!Objects.equals(this._errorMessages, other.getErrorMessages())) {
                return false;
            }
            if (!Objects.equals(this._lastSentMsgTimestamp, other.getLastSentMsgTimestamp())) {
                return false;
            }
            if (!Objects.equals(this._receivedMsgCount, other.getReceivedMsgCount())) {
                return false;
            }
            if (!Objects.equals(this._replyTime, other.getReplyTime())) {
                return false;
            }
            if (!Objects.equals(this._sentMsgCount, other.getSentMsgCount())) {
                return false;
            }
            if (!Objects.equals(this._unknownMsgReceived, other.getUnknownMsgReceived())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MessagesImpl otherImpl = (MessagesImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Messages");
            CodeHelpers.appendValue(helper, "_errorMessages", this._errorMessages);
            CodeHelpers.appendValue(helper, "_lastSentMsgTimestamp", this._lastSentMsgTimestamp);
            CodeHelpers.appendValue(helper, "_receivedMsgCount", this._receivedMsgCount);
            CodeHelpers.appendValue(helper, "_replyTime", this._replyTime);
            CodeHelpers.appendValue(helper, "_sentMsgCount", this._sentMsgCount);
            CodeHelpers.appendValue(helper, "_unknownMsgReceived", this._unknownMsgReceived);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

