/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.Topology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TopologyBuilder
implements Builder<Topology> {
    private List<Node> _node;
    private TopologyId _topologyId;
    private TopologyKey key;
    Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Collections.emptyMap();

    public TopologyBuilder() {
    }

    public TopologyBuilder(Topology base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this.key = base.key();
        this._topologyId = base.getTopologyId();
        this._node = base.getNode();
    }

    public TopologyKey key() {
        return this.key;
    }

    public List<Node> getNode() {
        return this._node;
    }

    public TopologyId getTopologyId() {
        return this._topologyId;
    }

    public <E$$ extends Augmentation<Topology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public TopologyBuilder withKey(TopologyKey key) {
        this.key = key;
        return this;
    }

    public TopologyBuilder setNode(List<Node> values) {
        this._node = values;
        return this;
    }

    public TopologyBuilder setTopologyId(TopologyId value) {
        this._topologyId = value;
        return this;
    }

    public TopologyBuilder addAugmentation(Class<? extends Augmentation<Topology>> augmentationType, Augmentation<Topology> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TopologyBuilder removeAugmentation(Class<? extends Augmentation<Topology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
    extends AbstractAugmentable<Topology>
    implements Topology {
        private final List<Node> _node;
        private final TopologyId _topologyId;
        private final TopologyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TopologyImpl(TopologyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new TopologyKey(base.getTopologyId());
            this._topologyId = this.key.getTopologyId();
            this._node = base.getNode();
        }

        @Override
        public TopologyKey key() {
            return this.key;
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopologyId() {
            return this._topologyId;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._topologyId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Topology.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Topology other = (Topology)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._topologyId, other.getTopologyId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TopologyImpl otherImpl = (TopologyImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Topology");
            CodeHelpers.appendValue(helper, "_node", this._node);
            CodeHelpers.appendValue(helper, "_topologyId", this._topologyId);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

