/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ClassType
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 7216175713280286513L;
    private final Uint8 _value;

    private static void check_valueRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..7]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public ClassType(Uint8 _value) {
        if (_value != null) {
            ClassType.check_valueRange(_value.shortValue());
        }
        CodeHelpers.requireValue(_value);
        this._value = _value;
    }

    @Deprecated(forRemoval=true)
    public ClassType(Short _value) {
        this(CodeHelpers.compatUint(_value));
    }

    public ClassType(ClassType source) {
        this._value = source._value;
    }

    public static ClassType getDefaultInstance(String defaultValue) {
        return new ClassType(Uint8.valueOf(defaultValue));
    }

    public Uint8 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassType)) {
            return false;
        }
        ClassType other = (ClassType)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(ClassType.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

