/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv6Destinations;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case.P2mpIpv6;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class P2mpIpv6Builder
implements Builder<P2mpIpv6> {
    private List<Ipv6AddressNoZone> _destinationIpv6Address;
    private P2mpLeaves _p2mpLeaves;
    private Ipv6AddressNoZone _sourceIpv6Address;
    Map<Class<? extends Augmentation<P2mpIpv6>>, Augmentation<P2mpIpv6>> augmentation = Collections.emptyMap();

    public P2mpIpv6Builder() {
    }

    public P2mpIpv6Builder(P2mpLeavesLeaf arg) {
        this._p2mpLeaves = arg.getP2mpLeaves();
    }

    public P2mpIpv6Builder(EndpointsIpv6Source arg) {
        this._sourceIpv6Address = arg.getSourceIpv6Address();
    }

    public P2mpIpv6Builder(Ipv6Destinations arg) {
        this._destinationIpv6Address = arg.getDestinationIpv6Address();
    }

    public P2mpIpv6Builder(P2mpIpv6 base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._destinationIpv6Address = base.getDestinationIpv6Address();
        this._p2mpLeaves = base.getP2mpLeaves();
        this._sourceIpv6Address = base.getSourceIpv6Address();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EndpointsIpv6Source) {
            this._sourceIpv6Address = ((EndpointsIpv6Source)arg).getSourceIpv6Address();
            isValidArg = true;
        }
        if (arg instanceof P2mpLeavesLeaf) {
            this._p2mpLeaves = ((P2mpLeavesLeaf)arg).getP2mpLeaves();
            isValidArg = true;
        }
        if (arg instanceof Ipv6Destinations) {
            this._destinationIpv6Address = ((Ipv6Destinations)arg).getDestinationIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv6Destinations]");
    }

    public List<Ipv6AddressNoZone> getDestinationIpv6Address() {
        return this._destinationIpv6Address;
    }

    public P2mpLeaves getP2mpLeaves() {
        return this._p2mpLeaves;
    }

    public Ipv6AddressNoZone getSourceIpv6Address() {
        return this._sourceIpv6Address;
    }

    public <E$$ extends Augmentation<P2mpIpv6>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public P2mpIpv6Builder setDestinationIpv6Address(List<Ipv6AddressNoZone> values) {
        this._destinationIpv6Address = values;
        return this;
    }

    public P2mpIpv6Builder setP2mpLeaves(P2mpLeaves value) {
        this._p2mpLeaves = value;
        return this;
    }

    public P2mpIpv6Builder setSourceIpv6Address(Ipv6AddressNoZone value) {
        this._sourceIpv6Address = value;
        return this;
    }

    public P2mpIpv6Builder addAugmentation(Class<? extends Augmentation<P2mpIpv6>> augmentationType, Augmentation<P2mpIpv6> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<P2mpIpv6>>, Augmentation<P2mpIpv6>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public P2mpIpv6Builder removeAugmentation(Class<? extends Augmentation<P2mpIpv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2mpIpv6 build() {
        return new P2mpIpv6Impl(this);
    }

    private static final class P2mpIpv6Impl
    extends AbstractAugmentable<P2mpIpv6>
    implements P2mpIpv6 {
        private final List<Ipv6AddressNoZone> _destinationIpv6Address;
        private final P2mpLeaves _p2mpLeaves;
        private final Ipv6AddressNoZone _sourceIpv6Address;
        private int hash = 0;
        private volatile boolean hashValid = false;

        P2mpIpv6Impl(P2mpIpv6Builder base) {
            super(base.augmentation);
            this._destinationIpv6Address = base.getDestinationIpv6Address();
            this._p2mpLeaves = base.getP2mpLeaves();
            this._sourceIpv6Address = base.getSourceIpv6Address();
        }

        @Override
        public List<Ipv6AddressNoZone> getDestinationIpv6Address() {
            return this._destinationIpv6Address;
        }

        @Override
        public P2mpLeaves getP2mpLeaves() {
            return this._p2mpLeaves;
        }

        @Override
        public Ipv6AddressNoZone getSourceIpv6Address() {
            return this._sourceIpv6Address;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destinationIpv6Address);
            result = 31 * result + Objects.hashCode(this._p2mpLeaves);
            result = 31 * result + Objects.hashCode(this._sourceIpv6Address);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!P2mpIpv6.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            P2mpIpv6 other = (P2mpIpv6)obj;
            if (!Objects.equals(this._destinationIpv6Address, other.getDestinationIpv6Address())) {
                return false;
            }
            if (!Objects.equals(this._p2mpLeaves, other.getP2mpLeaves())) {
                return false;
            }
            if (!Objects.equals(this._sourceIpv6Address, other.getSourceIpv6Address())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                P2mpIpv6Impl otherImpl = (P2mpIpv6Impl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("P2mpIpv6");
            CodeHelpers.appendValue(helper, "_destinationIpv6Address", this._destinationIpv6Address);
            CodeHelpers.appendValue(helper, "_p2mpLeaves", this._p2mpLeaves);
            CodeHelpers.appendValue(helper, "_sourceIpv6Address", this._sourceIpv6Address);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

