/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Endpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EndpointsObjBuilder
implements Builder<EndpointsObj> {
    private AddressFamily _addressFamily;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> augmentation = Collections.emptyMap();

    public EndpointsObjBuilder() {
    }

    public EndpointsObjBuilder(Object arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public EndpointsObjBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public EndpointsObjBuilder(Endpoints arg) {
        this._addressFamily = arg.getAddressFamily();
    }

    public EndpointsObjBuilder(EndpointsObj base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((java.lang.Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._addressFamily = base.getAddressFamily();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Endpoints) {
            this._addressFamily = ((Endpoints)arg).getAddressFamily();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Endpoints, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object]");
    }

    public AddressFamily getAddressFamily() {
        return this._addressFamily;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<EndpointsObj>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public EndpointsObjBuilder setAddressFamily(AddressFamily value) {
        this._addressFamily = value;
        return this;
    }

    public EndpointsObjBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public EndpointsObjBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public EndpointsObjBuilder addAugmentation(Class<? extends Augmentation<EndpointsObj>> augmentationType, Augmentation<EndpointsObj> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EndpointsObjBuilder removeAugmentation(Class<? extends Augmentation<EndpointsObj>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public EndpointsObj build() {
        return new EndpointsObjImpl(this);
    }

    private static final class EndpointsObjImpl
    extends AbstractAugmentable<EndpointsObj>
    implements EndpointsObj {
        private final AddressFamily _addressFamily;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EndpointsObjImpl(EndpointsObjBuilder base) {
            super(base.augmentation);
            this._addressFamily = base.getAddressFamily();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        @Override
        public AddressFamily getAddressFamily() {
            return this._addressFamily;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._addressFamily);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EndpointsObj.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            EndpointsObj other = (EndpointsObj)obj;
            if (!Objects.equals(this._addressFamily, other.getAddressFamily())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EndpointsObjImpl otherImpl = (EndpointsObjImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("EndpointsObj");
            CodeHelpers.appendValue(helper, "_addressFamily", this._addressFamily);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

