/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class LoadBalancingBuilder
implements Builder<LoadBalancing> {
    private Uint8 _maxLsp;
    private Bandwidth _minBandwidth;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> augmentation = Collections.emptyMap();

    public LoadBalancingBuilder() {
    }

    public LoadBalancingBuilder(Object arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LoadBalancingBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LoadBalancingBuilder(LoadBalancing base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((java.lang.Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._maxLsp = base.getMaxLsp();
        this._minBandwidth = base.getMinBandwidth();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object]");
    }

    public Uint8 getMaxLsp() {
        return this._maxLsp;
    }

    public Bandwidth getMinBandwidth() {
        return this._minBandwidth;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<LoadBalancing>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public LoadBalancingBuilder setMaxLsp(Uint8 value) {
        this._maxLsp = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public LoadBalancingBuilder setMaxLsp(Short value) {
        return this.setMaxLsp(CodeHelpers.compatUint(value));
    }

    public LoadBalancingBuilder setMinBandwidth(Bandwidth value) {
        this._minBandwidth = value;
        return this;
    }

    public LoadBalancingBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LoadBalancingBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LoadBalancingBuilder addAugmentation(Class<? extends Augmentation<LoadBalancing>> augmentationType, Augmentation<LoadBalancing> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LoadBalancingBuilder removeAugmentation(Class<? extends Augmentation<LoadBalancing>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LoadBalancing build() {
        return new LoadBalancingImpl(this);
    }

    private static final class LoadBalancingImpl
    extends AbstractAugmentable<LoadBalancing>
    implements LoadBalancing {
        private final Uint8 _maxLsp;
        private final Bandwidth _minBandwidth;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        LoadBalancingImpl(LoadBalancingBuilder base) {
            super(base.augmentation);
            this._maxLsp = base.getMaxLsp();
            this._minBandwidth = base.getMinBandwidth();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        @Override
        public Uint8 getMaxLsp() {
            return this._maxLsp;
        }

        @Override
        public Bandwidth getMinBandwidth() {
            return this._minBandwidth;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxLsp);
            result = 31 * result + Objects.hashCode(this._minBandwidth);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LoadBalancing.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            LoadBalancing other = (LoadBalancing)obj;
            if (!Objects.equals(this._maxLsp, other.getMaxLsp())) {
                return false;
            }
            if (!Objects.equals(this._minBandwidth, other.getMinBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LoadBalancingImpl otherImpl = (LoadBalancingImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("LoadBalancing");
            CodeHelpers.appendValue(helper, "_maxLsp", this._maxLsp);
            CodeHelpers.appendValue(helper, "_minBandwidth", this._minBandwidth);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

