/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class OpenBuilder
implements Builder<Open> {
    private Uint8 _deadTimer;
    private Uint8 _keepalive;
    private Uint8 _sessionId;
    private Tlvs _tlvs;
    private ProtocolVersion _version;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = Collections.emptyMap();

    public OpenBuilder() {
    }

    public OpenBuilder(Object arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public OpenBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public OpenBuilder(Open base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((java.lang.Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._deadTimer = base.getDeadTimer();
        this._keepalive = base.getKeepalive();
        this._sessionId = base.getSessionId();
        this._tlvs = base.getTlvs();
        this._version = base.getVersion();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object]");
    }

    public Uint8 getDeadTimer() {
        return this._deadTimer;
    }

    public Uint8 getKeepalive() {
        return this._keepalive;
    }

    public Uint8 getSessionId() {
        return this._sessionId;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<Open>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDeadTimerRange(short value) {
    }

    public OpenBuilder setDeadTimer(Uint8 value) {
        if (value != null) {
            OpenBuilder.checkDeadTimerRange(value.shortValue());
        }
        this._deadTimer = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public OpenBuilder setDeadTimer(Short value) {
        return this.setDeadTimer(CodeHelpers.compatUint(value));
    }

    private static void checkKeepaliveRange(short value) {
    }

    public OpenBuilder setKeepalive(Uint8 value) {
        if (value != null) {
            OpenBuilder.checkKeepaliveRange(value.shortValue());
        }
        this._keepalive = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public OpenBuilder setKeepalive(Short value) {
        return this.setKeepalive(CodeHelpers.compatUint(value));
    }

    public OpenBuilder setSessionId(Uint8 value) {
        this._sessionId = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public OpenBuilder setSessionId(Short value) {
        return this.setSessionId(CodeHelpers.compatUint(value));
    }

    public OpenBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public OpenBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public OpenBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public OpenBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public OpenBuilder addAugmentation(Class<? extends Augmentation<Open>> augmentationType, Augmentation<Open> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Open>>, Augmentation<Open>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OpenBuilder removeAugmentation(Class<? extends Augmentation<Open>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Open build() {
        return new OpenImpl(this);
    }

    private static final class OpenImpl
    extends AbstractAugmentable<Open>
    implements Open {
        private final Uint8 _deadTimer;
        private final Uint8 _keepalive;
        private final Uint8 _sessionId;
        private final Tlvs _tlvs;
        private final ProtocolVersion _version;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OpenImpl(OpenBuilder base) {
            super(base.augmentation);
            this._deadTimer = base.getDeadTimer();
            this._keepalive = base.getKeepalive();
            this._sessionId = base.getSessionId();
            this._tlvs = base.getTlvs();
            this._version = base.getVersion();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        @Override
        public Uint8 getDeadTimer() {
            return this._deadTimer;
        }

        @Override
        public Uint8 getKeepalive() {
            return this._keepalive;
        }

        @Override
        public Uint8 getSessionId() {
            return this._sessionId;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadTimer);
            result = 31 * result + Objects.hashCode(this._keepalive);
            result = 31 * result + Objects.hashCode(this._sessionId);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Open.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Open other = (Open)obj;
            if (!Objects.equals(this._deadTimer, other.getDeadTimer())) {
                return false;
            }
            if (!Objects.equals(this._keepalive, other.getKeepalive())) {
                return false;
            }
            if (!Objects.equals(this._sessionId, other.getSessionId())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OpenImpl otherImpl = (OpenImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Open");
            CodeHelpers.appendValue(helper, "_deadTimer", this._deadTimer);
            CodeHelpers.appendValue(helper, "_keepalive", this._keepalive);
            CodeHelpers.appendValue(helper, "_sessionId", this._sessionId);
            CodeHelpers.appendValue(helper, "_tlvs", this._tlvs);
            CodeHelpers.appendValue(helper, "_version", this._version);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

