/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VendorInformationObjectBuilder
implements Builder<VendorInformationObject> {
    private EnterpriseNumber _enterpriseNumber;
    private EnterpriseSpecificInformation _enterpriseSpecificInformation;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> augmentation = Collections.emptyMap();

    public VendorInformationObjectBuilder() {
    }

    public VendorInformationObjectBuilder(Object arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public VendorInformationObjectBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public VendorInformationObjectBuilder(VendorInformation arg) {
        this._enterpriseNumber = arg.getEnterpriseNumber();
        this._enterpriseSpecificInformation = arg.getEnterpriseSpecificInformation();
    }

    public VendorInformationObjectBuilder(VendorInformationObject base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((java.lang.Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VendorInformation) {
            this._enterpriseNumber = ((VendorInformation)arg).getEnterpriseNumber();
            this._enterpriseSpecificInformation = ((VendorInformation)arg).getEnterpriseSpecificInformation();
            isValidArg = true;
        }
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformation, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object]");
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return this._enterpriseNumber;
    }

    public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
        return this._enterpriseSpecificInformation;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E$$ extends Augmentation<VendorInformationObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public VendorInformationObjectBuilder setEnterpriseNumber(EnterpriseNumber value) {
        this._enterpriseNumber = value;
        return this;
    }

    public VendorInformationObjectBuilder setEnterpriseSpecificInformation(EnterpriseSpecificInformation value) {
        this._enterpriseSpecificInformation = value;
        return this;
    }

    public VendorInformationObjectBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public VendorInformationObjectBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public VendorInformationObjectBuilder addAugmentation(Class<? extends Augmentation<VendorInformationObject>> augmentationType, Augmentation<VendorInformationObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VendorInformationObjectBuilder removeAugmentation(Class<? extends Augmentation<VendorInformationObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public VendorInformationObject build() {
        return new VendorInformationObjectImpl(this);
    }

    private static final class VendorInformationObjectImpl
    extends AbstractAugmentable<VendorInformationObject>
    implements VendorInformationObject {
        private final EnterpriseNumber _enterpriseNumber;
        private final EnterpriseSpecificInformation _enterpriseSpecificInformation;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private int hash = 0;
        private volatile boolean hashValid = false;

        VendorInformationObjectImpl(VendorInformationObjectBuilder base) {
            super(base.augmentation);
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
        }

        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return this._enterpriseNumber;
        }

        @Override
        public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
            return this._enterpriseSpecificInformation;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._enterpriseNumber);
            result = 31 * result + Objects.hashCode(this._enterpriseSpecificInformation);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VendorInformationObject.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            VendorInformationObject other = (VendorInformationObject)obj;
            if (!Objects.equals(this._enterpriseNumber, other.getEnterpriseNumber())) {
                return false;
            }
            if (!Objects.equals(this._enterpriseSpecificInformation, other.getEnterpriseSpecificInformation())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VendorInformationObjectImpl otherImpl = (VendorInformationObjectImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("VendorInformationObject");
            CodeHelpers.appendValue(helper, "_enterpriseNumber", this._enterpriseNumber);
            CodeHelpers.appendValue(helper, "_enterpriseSpecificInformation", this._enterpriseSpecificInformation);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

