/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum AssociationType implements Enumeration
{
    Reserved(0, "reserved"),
    Recovery(1, "recovery");

    private static final Map<String, AssociationType> NAME_MAP;
    private static final Map<Integer, AssociationType> VALUE_MAP;
    private final String name;
    private final int value;

    private AssociationType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    public static Optional<AssociationType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static AssociationType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder<String, AssociationType> nb = ImmutableMap.builder();
        ImmutableMap.Builder<Integer, AssociationType> vb = ImmutableMap.builder();
        for (AssociationType enumItem : AssociationType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

