/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.metric.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.metric.object.MetricObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class MetricObjectBuilder
implements Builder<MetricObject> {
    private Uint8 _metricType;
    private Float32 _value;
    private Boolean _bound;
    private Boolean _computed;
    Map<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>> augmentation = Collections.emptyMap();

    public MetricObjectBuilder() {
    }

    public MetricObjectBuilder(RsvpTeObject arg) {
    }

    public MetricObjectBuilder(MetricObject base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._metricType = base.getMetricType();
        this._value = base.getValue();
        this._bound = base.isBound();
        this._computed = base.isComputed();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RsvpTeObject) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject]");
    }

    public Uint8 getMetricType() {
        return this._metricType;
    }

    public Float32 getValue() {
        return this._value;
    }

    public Boolean isBound() {
        return this._bound;
    }

    public Boolean isComputed() {
        return this._computed;
    }

    public <E$$ extends Augmentation<MetricObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public MetricObjectBuilder setMetricType(Uint8 value) {
        this._metricType = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public MetricObjectBuilder setMetricType(Short value) {
        return this.setMetricType(CodeHelpers.compatUint(value));
    }

    public MetricObjectBuilder setValue(Float32 value) {
        this._value = value;
        return this;
    }

    public MetricObjectBuilder setBound(Boolean value) {
        this._bound = value;
        return this;
    }

    public MetricObjectBuilder setComputed(Boolean value) {
        this._computed = value;
        return this;
    }

    public MetricObjectBuilder addAugmentation(Class<? extends Augmentation<MetricObject>> augmentationType, Augmentation<MetricObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MetricObjectBuilder removeAugmentation(Class<? extends Augmentation<MetricObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MetricObject build() {
        return new MetricObjectImpl(this);
    }

    private static final class MetricObjectImpl
    extends AbstractAugmentable<MetricObject>
    implements MetricObject {
        private final Uint8 _metricType;
        private final Float32 _value;
        private final Boolean _bound;
        private final Boolean _computed;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MetricObjectImpl(MetricObjectBuilder base) {
            super(base.augmentation);
            this._metricType = base.getMetricType();
            this._value = base.getValue();
            this._bound = base.isBound();
            this._computed = base.isComputed();
        }

        @Override
        public Uint8 getMetricType() {
            return this._metricType;
        }

        @Override
        public Float32 getValue() {
            return this._value;
        }

        @Override
        public Boolean isBound() {
            return this._bound;
        }

        @Override
        public Boolean isComputed() {
            return this._computed;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._metricType);
            result = 31 * result + Objects.hashCode(this._value);
            result = 31 * result + Objects.hashCode(this._bound);
            result = 31 * result + Objects.hashCode(this._computed);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MetricObject.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            MetricObject other = (MetricObject)obj;
            if (!Objects.equals(this._metricType, other.getMetricType())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (!Objects.equals(this._bound, other.isBound())) {
                return false;
            }
            if (!Objects.equals(this._computed, other.isComputed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MetricObjectImpl otherImpl = (MetricObjectImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("MetricObject");
            CodeHelpers.appendValue(helper, "_metricType", this._metricType);
            CodeHelpers.appendValue(helper, "_value", this._value);
            CodeHelpers.appendValue(helper, "_bound", this._bound);
            CodeHelpers.appendValue(helper, "_computed", this._computed);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

