/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.uint24.rev200104;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class Uint24
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 4657380447466564727L;
    private final Uint32 _value;

    private static void check_valueRange(long value) {
        if (value <= 0xFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..16777215]]", value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public Uint24(Uint32 _value) {
        if (_value != null) {
            Uint24.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue(_value);
        this._value = _value;
    }

    @Deprecated(forRemoval=true)
    public Uint24(Long _value) {
        this(CodeHelpers.compatUint(_value));
    }

    public Uint24(Uint24 source) {
        this._value = source._value;
    }

    public static Uint24 getDefaultInstance(String defaultValue) {
        return new Uint24(Uint32.valueOf(defaultValue));
    }

    public Uint32 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode(this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Uint24)) {
            return false;
        }
        Uint24 other = (Uint24)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Uint24.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

