/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SourceBuilder
implements Builder<Source> {
    private NodeId _sourceNode;
    private TpId _sourceTp;
    Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();

    public SourceBuilder() {
    }

    public SourceBuilder(Source base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this._sourceNode = base.getSourceNode();
        this._sourceTp = base.getSourceTp();
    }

    public NodeId getSourceNode() {
        return this._sourceNode;
    }

    public TpId getSourceTp() {
        return this._sourceTp;
    }

    public <E$$ extends Augmentation<Source>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public SourceBuilder setSourceNode(NodeId value) {
        this._sourceNode = value;
        return this;
    }

    public SourceBuilder setSourceTp(TpId value) {
        this._sourceTp = value;
        return this;
    }

    public SourceBuilder addAugmentation(Class<? extends Augmentation<Source>> augmentationType, Augmentation<Source> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SourceBuilder removeAugmentation(Class<? extends Augmentation<Source>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Source build() {
        return new SourceImpl(this);
    }

    private static final class SourceImpl
    extends AbstractAugmentable<Source>
    implements Source {
        private final NodeId _sourceNode;
        private final TpId _sourceTp;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SourceImpl(SourceBuilder base) {
            super(base.augmentation);
            this._sourceNode = base.getSourceNode();
            this._sourceTp = base.getSourceTp();
        }

        @Override
        public NodeId getSourceNode() {
            return this._sourceNode;
        }

        @Override
        public TpId getSourceTp() {
            return this._sourceTp;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._sourceNode);
            result = 31 * result + Objects.hashCode(this._sourceTp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Source.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Source other = (Source)obj;
            if (!Objects.equals(this._sourceNode, other.getSourceNode())) {
                return false;
            }
            if (!Objects.equals(this._sourceTp, other.getSourceTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SourceImpl otherImpl = (SourceImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Source");
            CodeHelpers.appendValue(helper, "_sourceNode", this._sourceNode);
            CodeHelpers.appendValue(helper, "_sourceTp", this._sourceTp);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

