/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeBuilder
implements Builder<Node> {
    private NodeId _nodeId;
    private List<SupportingNode> _supportingNode;
    private List<TerminationPoint> _terminationPoint;
    private NodeKey key;
    Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();

    public NodeBuilder() {
    }

    public NodeBuilder(NodeAttributes arg) {
        this._nodeId = arg.getNodeId();
        this._supportingNode = arg.getSupportingNode();
    }

    public NodeBuilder(Node base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)((Object)base)).augmentations()).isEmpty()) {
            this.augmentation = new HashMap(aug);
        }
        this.key = base.key();
        this._nodeId = base.getNodeId();
        this._supportingNode = base.getSupportingNode();
        this._terminationPoint = base.getTerminationPoint();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeAttributes) {
            this._nodeId = ((NodeAttributes)arg).getNodeId();
            this._supportingNode = ((NodeAttributes)arg).getSupportingNode();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes]");
    }

    public NodeKey key() {
        return this.key;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public List<SupportingNode> getSupportingNode() {
        return this._supportingNode;
    }

    public List<TerminationPoint> getTerminationPoint() {
        return this._terminationPoint;
    }

    public <E$$ extends Augmentation<Node>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public NodeBuilder withKey(NodeKey key) {
        this.key = key;
        return this;
    }

    public NodeBuilder setNodeId(NodeId value) {
        this._nodeId = value;
        return this;
    }

    public NodeBuilder setSupportingNode(List<SupportingNode> values) {
        this._supportingNode = values;
        return this;
    }

    public NodeBuilder setTerminationPoint(List<TerminationPoint> values) {
        this._terminationPoint = values;
        return this;
    }

    public NodeBuilder addAugmentation(Class<? extends Augmentation<Node>> augmentationType, Augmentation<Node> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeBuilder removeAugmentation(Class<? extends Augmentation<Node>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    extends AbstractAugmentable<Node>
    implements Node {
        private final NodeId _nodeId;
        private final List<SupportingNode> _supportingNode;
        private final List<TerminationPoint> _terminationPoint;
        private final NodeKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeImpl(NodeBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new NodeKey(base.getNodeId());
            this._nodeId = this.key.getNodeId();
            this._supportingNode = base.getSupportingNode();
            this._terminationPoint = base.getTerminationPoint();
        }

        @Override
        public NodeKey key() {
            return this.key;
        }

        @Override
        public NodeId getNodeId() {
            return this._nodeId;
        }

        @Override
        public List<SupportingNode> getSupportingNode() {
            return this._supportingNode;
        }

        @Override
        public List<TerminationPoint> getTerminationPoint() {
            return this._terminationPoint;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._supportingNode);
            result = 31 * result + Objects.hashCode(this._terminationPoint);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Node.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Node other = (Node)obj;
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._supportingNode, other.getSupportingNode())) {
                return false;
            }
            if (!Objects.equals(this._terminationPoint, other.getTerminationPoint())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeImpl otherImpl = (NodeImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : ((ImmutableMap)this.augmentations()).entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Node");
            CodeHelpers.appendValue(helper, "_nodeId", this._nodeId);
            CodeHelpers.appendValue(helper, "_supportingNode", this._supportingNode);
            CodeHelpers.appendValue(helper, "_terminationPoint", this._terminationPoint);
            CodeHelpers.appendValue(helper, "augmentation", ((ImmutableMap)this.augmentations()).values());
            return helper.toString();
        }
    }
}

