/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.ExtensibleObject;
import org.opendaylight.yangtools.concepts.ObjectExtension;

@Beta
public final class ObjectExtensions<O extends ExtensibleObject<O, E>, E extends ObjectExtension<O, E>>
extends AbstractMap<Class<? extends E>, E>
implements ClassToInstanceMap<E> {
    private final @NonNull ImmutableSet<Class<? extends E>> extensions;
    private final @NonNull Object object;

    ObjectExtensions(ImmutableSet<Class<? extends E>> extensions, Object object) {
        this.extensions = Objects.requireNonNull(extensions);
        this.object = Objects.requireNonNull(object);
    }

    @SafeVarargs
    public static <T, O extends ExtensibleObject<O, E>, E extends ObjectExtension<O, E>> @NonNull Factory<T, O, E> factory(Class<T> objClass, Class<? extends E> ... extensions) {
        ImmutableSet<Class<E>> set = ImmutableSet.copyOf(extensions);
        for (Class clazz : set) {
            Preconditions.checkArgument(clazz.isAssignableFrom(objClass), "%s is not a valid extension %s", objClass, (Object)clazz);
        }
        return new Factory(set);
    }

    @Override
    public int size() {
        return this.extensions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.extensions.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.object.equals(value);
    }

    @Override
    public E get(Object key) {
        return (E)(this.containsKey(key) ? (ObjectExtension)((Class)key).cast(this.object) : null);
    }

    @Override
    public E put(Class<? extends E> key, E value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Class<? extends E>, ? extends E> m3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Class<? extends E>> keySet() {
        return this.extensions;
    }

    @Override
    public Collection<E> values() {
        return new Values(this.object, this.extensions.size());
    }

    @Override
    public Set<Map.Entry<Class<? extends E>, E>> entrySet() {
        return new EntrySet();
    }

    @Override
    public <T extends E> T getInstance(Class<T> type) {
        return (T)(this.extensions.contains(Objects.requireNonNull(type)) ? (ObjectExtension)type.cast(this.object) : null);
    }

    @Override
    public <T extends E> T putInstance(Class<T> type, T value) {
        throw new UnsupportedOperationException();
    }

    public static final class Factory<T, O extends ExtensibleObject<O, E>, E extends ObjectExtension<O, E>> {
        private final @NonNull ImmutableSet<Class<? extends E>> extensions;

        Factory(ImmutableSet<Class<? extends E>> extensions) {
            this.extensions = Objects.requireNonNull(extensions);
        }

        public @NonNull ClassToInstanceMap<E> newInstance(T object) {
            return new ObjectExtensions(this.extensions, object);
        }
    }

    private static final class Values<E>
    extends AbstractList<E> {
        private final @NonNull E instance;
        private final int size;

        Values(@NonNull Object instance, int size) {
            this.instance = instance;
            this.size = size;
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return this.instance;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Class<? extends E>, E>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Class<? extends E>, E>> iterator() {
            return Iterators.transform(ObjectExtensions.this.extensions.iterator(), ext -> new AbstractMap.SimpleImmutableEntry<Class, ObjectExtension>((Class)ext, (ObjectExtension)ext.cast(ObjectExtensions.this.object)));
        }

        @Override
        public int size() {
            return ObjectExtensions.this.extensions.size();
        }
    }
}

