/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ForwardingObject;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Delegator;

@Beta
@NonNullByDefault
public abstract class ForwardingIdentityObject<T>
extends ForwardingObject
implements Delegator<T> {
    protected ForwardingIdentityObject() {
    }

    public static <T> ForwardingIdentityObject<T> of(T obj) {
        return ForwardingIdentityObject.checkedOf(Objects.requireNonNull(obj));
    }

    @Override
    public final @NonNull T getDelegate() {
        return this.delegate();
    }

    public final int hashCode() {
        return System.identityHashCode(this.delegate());
    }

    public final boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof ForwardingIdentityObject && this.delegate() == ((ForwardingIdentityObject)obj).delegate();
    }

    protected abstract @NonNull T delegate();

    private static <T> ForwardingIdentityObject<T> checkedOf(final @NonNull T delegate) {
        return new ForwardingIdentityObject<T>(){

            @Override
            protected @NonNull T delegate() {
                return delegate;
            }
        };
    }
}

