/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.ConstantArrayCollection;
import org.opendaylight.yangtools.util.MutableOffsetMap;
import org.opendaylight.yangtools.util.OffsetMapCache;
import org.opendaylight.yangtools.util.SharedSingletonMap;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;

@Beta
public abstract class ImmutableOffsetMap<K, V>
implements UnmodifiableMapPhase<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient @NonNull ImmutableMap<K, Integer> offsets;
    private final transient @NonNull V[] objects;
    private transient int hashCode;
    private static final Field OFFSETS_FIELD = ImmutableOffsetMap.fieldFor("offsets");
    private static final Field ARRAY_FIELD = ImmutableOffsetMap.fieldFor("objects");

    ImmutableOffsetMap(ImmutableMap<K, Integer> offsets, V[] objects) {
        this.offsets = Objects.requireNonNull(offsets);
        this.objects = Objects.requireNonNull(objects);
        Preconditions.checkArgument(offsets.size() == objects.length);
    }

    @Override
    public abstract @NonNull MutableOffsetMap<K, V> toModifiableMap();

    abstract void setFields(List<K> var1, V[] var2) throws IOException;

    public static <K, V> @NonNull Map<K, V> orderedCopyOf(@NonNull Map<K, V> map) {
        Map<K, V> common = ImmutableOffsetMap.commonCopy(map);
        if (common != null) {
            return common;
        }
        int size = map.size();
        if (size == 1) {
            Map.Entry<K, V> e = map.entrySet().iterator().next();
            return SharedSingletonMap.orderedOf(e.getKey(), e.getValue());
        }
        ImmutableMap<K, Integer> offsets = OffsetMapCache.orderedOffsets(map.keySet());
        Object[] array = new Object[offsets.size()];
        for (Map.Entry<K, V> e : map.entrySet()) {
            array[offsets.get(e.getKey()).intValue()] = e.getValue();
        }
        return new Ordered<K, Object>(offsets, array);
    }

    public static <K, V> @NonNull Map<K, V> unorderedCopyOf(@NonNull Map<K, V> map) {
        Map<K, V> common = ImmutableOffsetMap.commonCopy(map);
        if (common != null) {
            return common;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> e = map.entrySet().iterator().next();
            return SharedSingletonMap.unorderedOf(e.getKey(), e.getValue());
        }
        ImmutableMap<K, Integer> offsets = OffsetMapCache.unorderedOffsets(map.keySet());
        Object[] array = new Object[offsets.size()];
        for (Map.Entry<K, V> e : map.entrySet()) {
            array[offsets.get(e.getKey()).intValue()] = e.getValue();
        }
        return new Unordered<K, Object>(offsets, array);
    }

    private static <K, V> @Nullable Map<K, V> commonCopy(@NonNull Map<K, V> map) {
        if (map instanceof ImmutableOffsetMap || map instanceof SharedSingletonMap) {
            return map;
        }
        if (map instanceof MutableOffsetMap) {
            return ((MutableOffsetMap)map).toUnmodifiableMap();
        }
        if (map.isEmpty()) {
            return ImmutableMap.of();
        }
        return null;
    }

    @Override
    public final int size() {
        return this.offsets.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.offsets.isEmpty();
    }

    @Override
    public final int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 0;
        for (Map.Entry e : this.offsets.entrySet()) {
            result += e.getKey().hashCode() ^ this.objects[(Integer)e.getValue()].hashCode();
        }
        this.hashCode = result;
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        if (obj instanceof ImmutableOffsetMap) {
            ImmutableOffsetMap om = (ImmutableOffsetMap)obj;
            if (this.offsets.equals(om.offsets)) {
                return Arrays.deepEquals(this.objects, om.objects);
            }
        } else if (obj instanceof MutableOffsetMap) {
            return obj.equals(this);
        }
        Map other = (Map)obj;
        if (this.size() != other.size() || !this.keySet().equals(other.keySet())) {
            return false;
        }
        try {
            for (Map.Entry e : this.offsets.entrySet()) {
                if (this.objects[(Integer)e.getValue()].equals(other.get(e.getKey()))) continue;
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.offsets.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        for (V o : this.objects) {
            if (!value.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object key) {
        Integer offset = this.offsets.get(key);
        return offset == null ? null : (V)this.objects[offset];
    }

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<K> keySet() {
        return this.offsets.keySet();
    }

    @Override
    public final @NonNull Collection<V> values() {
        return new ConstantArrayCollection<V>(this.objects);
    }

    @Override
    public final @NonNull Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("{");
        Iterator it = ((ImmutableSet)this.offsets.keySet()).iterator();
        int offset = 0;
        while (it.hasNext()) {
            sb.append(it.next()).append('=').append(this.objects[offset++]);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }

    final @NonNull ImmutableMap<K, Integer> offsets() {
        return this.offsets;
    }

    final @NonNull V[] objects() {
        return this.objects;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.offsets.size());
        for (Map.Entry<K, V> e : this.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
    }

    private static @NonNull Field fieldFor(@NonNull String name) {
        Field f;
        try {
            f = ImmutableOffsetMap.class.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException("Failed to lookup field " + name, e);
        }
        f.setAccessible(true);
        return f;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void setField(@NonNull ImmutableOffsetMap<?, ?> map, @NonNull Field field, Object value) throws IOException {
        try {
            field.set(map, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException("Failed to set field " + field, e);
        }
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        int s2 = in.readInt();
        ArrayList<Object> keys = new ArrayList<Object>(s2);
        Object[] values = new Object[s2];
        for (int i = 0; i < s2; ++i) {
            keys.add(in.readObject());
            values[i] = in.readObject();
        }
        this.setFields(keys, values);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public @NonNull Iterator<Map.Entry<K, V>> iterator() {
            final Iterator it = ((ImmutableSet)ImmutableOffsetMap.this.offsets.entrySet()).iterator();
            return new UnmodifiableIterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry e = (Map.Entry)it.next();
                    return new AbstractMap.SimpleImmutableEntry(e.getKey(), ImmutableOffsetMap.this.objects[(Integer)e.getValue()]);
                }
            };
        }

        @Override
        public int size() {
            return ImmutableOffsetMap.this.offsets.size();
        }
    }

    static final class Unordered<K, V>
    extends ImmutableOffsetMap<K, V> {
        private static final long serialVersionUID = 1L;

        Unordered(ImmutableMap<K, Integer> offsets, V[] objects) {
            super(offsets, objects);
        }

        @Override
        public @NonNull MutableOffsetMap<K, V> toModifiableMap() {
            return MutableOffsetMap.unorderedCopyOf(this);
        }

        @Override
        void setFields(List<K> keys, V[] values) throws IOException {
            ImmutableMap<K, Integer> newOffsets = OffsetMapCache.unorderedOffsets(keys);
            ImmutableOffsetMap.setField(this, OFFSETS_FIELD, newOffsets);
            ImmutableOffsetMap.setField(this, ARRAY_FIELD, OffsetMapCache.adjustedArray(newOffsets, keys, values));
        }
    }

    static final class Ordered<K, V>
    extends ImmutableOffsetMap<K, V> {
        private static final long serialVersionUID = 1L;

        Ordered(ImmutableMap<K, Integer> offsets, V[] objects) {
            super(offsets, objects);
        }

        @Override
        public @NonNull MutableOffsetMap<K, V> toModifiableMap() {
            return MutableOffsetMap.orderedCopyOf(this);
        }

        @Override
        void setFields(List<K> keys, V[] values) throws IOException {
            ImmutableOffsetMap.setField(this, OFFSETS_FIELD, OffsetMapCache.orderedOffsets(keys));
            ImmutableOffsetMap.setField(this, ARRAY_FIELD, values);
        }
    }
}

