/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.EventListener;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.concepts.ObjectRegistration;

public final class ListenerRegistry<T extends EventListener>
implements Mutable {
    private final Set<ListenerRegistration<? extends T>> listeners = ConcurrentHashMap.newKeySet();
    private final Set<ListenerRegistration<T>> unmodifiableView = Collections.unmodifiableSet(this.listeners);
    private final String name;

    private ListenerRegistry(String name) {
        this.name = name;
    }

    public static <T extends EventListener> @NonNull ListenerRegistry<T> create() {
        return new ListenerRegistry<T>(null);
    }

    public static <T extends EventListener> @NonNull ListenerRegistry<T> create(@NonNull String name) {
        return new ListenerRegistry<T>(Objects.requireNonNull(name));
    }

    public @NonNull Set<? extends ListenerRegistration<? extends T>> getRegistrations() {
        return this.unmodifiableView;
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public Stream<? extends T> streamListeners() {
        return this.listeners.stream().map(ObjectRegistration::getInstance);
    }

    public <L extends T> @NonNull ListenerRegistration<L> register(L listener) {
        ListenerRegistrationImpl ret = new ListenerRegistrationImpl(listener, this.listeners::remove);
        this.listeners.add(ret);
        return ret;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("size", this.listeners.size()).toString();
    }

    private static final class ListenerRegistrationImpl<T extends EventListener>
    extends AbstractListenerRegistration<T> {
        private Consumer<ListenerRegistration<? super T>> removeCall;

        ListenerRegistrationImpl(T instance, Consumer<ListenerRegistration<? super T>> removeCall) {
            super(instance);
            this.removeCall = Objects.requireNonNull(removeCall);
        }

        @Override
        protected void removeRegistration() {
            this.removeCall.accept(this);
            this.removeCall = null;
        }
    }
}

