/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBatchingExecutor<K, T>
extends AbstractIdentifiable<String> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBatchingExecutor.class);
    private static final int MAX_NOTIFICATION_OFFER_MINUTES = 10;
    private static final long GIVE_UP_NANOS = TimeUnit.MINUTES.toNanos(10L);
    private static final long TASK_WAIT_NANOS = TimeUnit.MILLISECONDS.toNanos(10L);
    private final ConcurrentMap<K, DispatcherTask> dispatcherTasks = new ConcurrentHashMap<K, DispatcherTask>();
    private final @NonNull Executor executor;
    private final int maxQueueCapacity;

    AbstractBatchingExecutor(@NonNull String name, @NonNull Executor executor, int maxQueueCapacity) {
        super(name);
        this.executor = Objects.requireNonNull(executor);
        Preconditions.checkArgument(maxQueueCapacity > 0, "Invalid maxQueueCapacity %s must be > 0", maxQueueCapacity);
        this.maxQueueCapacity = maxQueueCapacity;
    }

    final int maxQueueCapacity() {
        return this.maxQueueCapacity;
    }

    final @NonNull Executor executor() {
        return this.executor;
    }

    final void submitTask(K key, T task) {
        this.submitTasks(key, Collections.singletonList(Objects.requireNonNull(task)));
    }

    final void submitTasks(K key, Iterable<T> tasks) {
        if (tasks == null || key == null) {
            return;
        }
        LOG.trace("{}: submitTasks for worker {}: {}", this.getIdentifier(), key, tasks);
        try {
            Iterator<T> it = tasks.iterator();
            while (true) {
                boolean completed;
                DispatcherTask task;
                if ((task = (DispatcherTask)this.dispatcherTasks.get(key)) == null) {
                    DispatcherTask newTask = new DispatcherTask(key, it);
                    task = this.dispatcherTasks.putIfAbsent(key, newTask);
                    if (task == null) {
                        this.runTask(key, newTask);
                        break;
                    }
                    it = newTask.recoverItems();
                }
                if (completed = task.submitTasks(it)) break;
                DispatcherTask newTask = new DispatcherTask(key, it);
                if (this.dispatcherTasks.replace(key, task, newTask)) {
                    this.runTask(key, newTask);
                    break;
                }
                it = newTask.recoverItems();
                LOG.debug("{}: retrying task queueing for {}", this.getIdentifier(), (Object)key);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{}: Interrupted trying to add to {} worker's queue", this.getIdentifier(), (Object)key);
        }
        LOG.trace("{}: submitTasks done for worker {}", this.getIdentifier(), (Object)key);
    }

    final Stream<DispatcherTask> streamTasks() {
        return this.dispatcherTasks.values().stream();
    }

    abstract void executeBatch(K var1, @NonNull ImmutableList<T> var2) throws Exception;

    private void runTask(K key, DispatcherTask task) {
        LOG.debug("{}: Submitting DispatcherTask for worker {}", this.getIdentifier(), (Object)key);
        this.executor.execute(task);
    }

    final class DispatcherTask
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private final Condition notEmpty = this.lock.newCondition();
        private final Condition notFull = this.lock.newCondition();
        private final @NonNull K key;
        private final @GuardedBy(value={"lock"}) Queue<T> queue = new ArrayDeque();
        private @GuardedBy(value={"lock"}) boolean exiting;

        DispatcherTask(@NonNull K key, Iterator<T> tasks) {
            this.key = Objects.requireNonNull(key);
            while (tasks.hasNext()) {
                Object task = tasks.next();
                if (task == null) continue;
                this.queue.add(task);
            }
        }

        @NonNull Iterator<T> recoverItems() {
            return this.queue.iterator();
        }

        @NonNull K key() {
            return this.key;
        }

        int size() {
            this.lock.lock();
            try {
                int n = this.queue.size();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * Unable to fully structure code
         */
        boolean submitTasks(@NonNull Iterator<T> tasks) throws InterruptedException {
            start = System.nanoTime();
            deadline = start + AbstractBatchingExecutor.GIVE_UP_NANOS;
            this.lock.lock();
            try {
                canWait = deadline - System.nanoTime();
                block6: while (true) {
                    if (this.exiting) {
                        var8_5 = false;
                        return var8_5;
                    }
                    avail = AbstractBatchingExecutor.this.maxQueueCapacity - this.queue.size();
                    if (avail <= 0) {
                        if (canWait <= 0L) {
                            AbstractBatchingExecutor.LOG.warn("{}: Failed to offer tasks {} to the queue for worker {}. Exceeded maximum allowable time of {} minutes; the worker is likely in an unrecoverable state (deadlock or endless loop). ", new Object[]{AbstractBatchingExecutor.this.getIdentifier(), ImmutableList.copyOf(tasks), this.key, 10});
                            var9_6 = true;
                            return var9_6;
                        }
                        canWait = this.notFull.awaitNanos(canWait);
                        continue;
                    }
                    i = 0;
                    while (true) {
                        if (i < avail) ** break;
                        continue block6;
                        if (!tasks.hasNext()) {
                            this.notEmpty.signal();
                            var10_7 = true;
                            return var10_7;
                        }
                        this.queue.add(tasks.next());
                        ++i;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private @GuardedBy(value={"lock"}) boolean waitForQueue() {
            long timeout = TASK_WAIT_NANOS;
            while (this.queue.isEmpty()) {
                if (timeout <= 0L) {
                    return false;
                }
                try {
                    timeout = this.notEmpty.awaitNanos(timeout);
                }
                catch (InterruptedException e) {
                    LOG.debug("{}: Interrupted trying to remove from {} worker's queue", AbstractBatchingExecutor.this.getIdentifier(), this.key);
                    return false;
                }
            }
            return true;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ImmutableList tasks;
                    this.lock.lock();
                    try {
                        if (!this.waitForQueue()) {
                            this.exiting = true;
                            break;
                        }
                        tasks = ImmutableList.copyOf(this.queue);
                        this.queue.clear();
                        this.notFull.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    this.invokeWorker(tasks);
                }
            }
            finally {
                AbstractBatchingExecutor.this.dispatcherTasks.remove(this.key, this);
            }
        }

        private void invokeWorker(@NonNull ImmutableList<T> tasks) {
            LOG.debug("{}: Invoking worker {} with tasks: {}", AbstractBatchingExecutor.this.getIdentifier(), this.key, tasks);
            try {
                AbstractBatchingExecutor.this.executeBatch(this.key, tasks);
            }
            catch (Exception e) {
                LOG.error("{}: Error invoking worker {} with {}", AbstractBatchingExecutor.this.getIdentifier(), this.key, tasks, e);
            }
        }
    }
}

