/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.concurrent.AbstractBatchingExecutor;
import org.opendaylight.yangtools.util.concurrent.ListenerNotificationQueueStats;
import org.opendaylight.yangtools.util.concurrent.NotificationManager;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManager;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManagerMXBean;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManagerMXBeanImpl;

@NonNullByDefault
abstract class AbstractQueuedNotificationManager<T, L, N>
extends AbstractBatchingExecutor<T, N>
implements NotificationManager<L, N> {
    private final QueuedNotificationManagerMXBean mxBean = new QueuedNotificationManagerMXBeanImpl(this);
    private final QueuedNotificationManager.BatchedInvoker<L, N> listenerInvoker;

    AbstractQueuedNotificationManager(String name, Executor executor, int maxQueueCapacity, QueuedNotificationManager.BatchedInvoker<L, N> listenerInvoker) {
        super(name, executor, maxQueueCapacity);
        this.listenerInvoker = Objects.requireNonNull(listenerInvoker);
    }

    public final Executor getExecutor() {
        return this.executor();
    }

    public final int getMaxQueueCapacity() {
        return this.maxQueueCapacity();
    }

    public final QueuedNotificationManagerMXBean getMXBean() {
        return this.mxBean;
    }

    public final List<ListenerNotificationQueueStats> getListenerNotificationQueueStats() {
        return this.streamTasks().map(t -> new ListenerNotificationQueueStats(t.key().toString(), t.size())).collect(Collectors.toList());
    }

    @Override
    public final void submitNotification(L listener, N notification) {
        if (listener != null && notification != null) {
            this.submitTask(this.wrap(listener), notification);
        }
    }

    @Override
    public final void submitNotifications(L listener, @Nullable Iterable<N> notifications) {
        if (listener != null && notifications != null) {
            this.submitTasks(this.wrap(listener), notifications);
        }
    }

    @Override
    final void executeBatch(T key, @NonNull ImmutableList<N> tasks) {
        this.listenerInvoker.invokeListener(this.unwrap(key), tasks);
    }

    abstract T wrap(L var1);

    abstract L unwrap(T var1);
}

