/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.concurrent.SettableBoolean;
import org.opendaylight.yangtools.util.concurrent.SettableBooleanThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncNotifyingListenableFutureTask<V>
extends FutureTask<V>
implements ListenableFuture<V> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncNotifyingListenableFutureTask.class);
    private static final SettableBooleanThreadLocal ON_TASK_COMPLETION_THREAD_TL = new SettableBooleanThreadLocal();
    private final ExecutionList executionList = new ExecutionList();

    private AsyncNotifyingListenableFutureTask(@NonNull Callable<V> callable) {
        super(callable);
    }

    private AsyncNotifyingListenableFutureTask(@NonNull Runnable runnable, @Nullable V result) {
        super(runnable, result);
    }

    public static <V> @NonNull AsyncNotifyingListenableFutureTask<V> create(@NonNull Callable<V> callable, @Nullable Executor listenerExecutor) {
        if (listenerExecutor == null) {
            return new AsyncNotifyingListenableFutureTask<V>(callable);
        }
        return new DelegatingAsyncNotifyingListenableFutureTask<V>(callable, listenerExecutor);
    }

    public static <V> @NonNull AsyncNotifyingListenableFutureTask<V> create(@NonNull Runnable runnable, @Nullable V result, @Nullable Executor listenerExecutor) {
        if (listenerExecutor == null) {
            return new AsyncNotifyingListenableFutureTask<V>(runnable, result);
        }
        return new DelegatingAsyncNotifyingListenableFutureTask<V>(runnable, result, listenerExecutor);
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.executionList.add(listener, executor);
    }

    public static void cleanStateForCurrentThread() {
        ON_TASK_COMPLETION_THREAD_TL.remove();
    }

    @Override
    protected void done() {
        SettableBoolean b = (SettableBoolean)ON_TASK_COMPLETION_THREAD_TL.get();
        b.set();
        try {
            this.executionList.execute();
        }
        finally {
            b.reset();
        }
    }

    private static final class DelegatingRunnable
    implements Runnable {
        private final Runnable delegate;
        private final Executor executor;

        DelegatingRunnable(Runnable delegate, Executor executor) {
            this.delegate = Objects.requireNonNull(delegate);
            this.executor = Objects.requireNonNull(executor);
        }

        @Override
        public void run() {
            if (((SettableBoolean)ON_TASK_COMPLETION_THREAD_TL.get()).isSet()) {
                LOG.trace("Submitting ListenenableFuture Runnable from thread {} to executor {}", (Object)Thread.currentThread().getName(), (Object)this.executor);
                this.executor.execute(this.delegate);
            } else {
                LOG.trace("Executing ListenenableFuture Runnable on this thread: {}", (Object)Thread.currentThread().getName());
                this.delegate.run();
            }
        }
    }

    private static final class DelegatingAsyncNotifyingListenableFutureTask<V>
    extends AsyncNotifyingListenableFutureTask<V> {
        private final @NonNull Executor listenerExecutor;

        private DelegatingAsyncNotifyingListenableFutureTask(Callable<V> callable, @NonNull Executor listenerExecutor) {
            super(callable);
            this.listenerExecutor = Objects.requireNonNull(listenerExecutor);
        }

        private DelegatingAsyncNotifyingListenableFutureTask(Runnable runnable, @Nullable V result, @NonNull Executor listenerExecutor) {
            super(runnable, result);
            this.listenerExecutor = Objects.requireNonNull(listenerExecutor);
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            super.addListener(new DelegatingRunnable(listener, this.listenerExecutor), executor);
        }
    }
}

