/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.MoreObjects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yangtools.util.concurrent.CountingRejectedExecutionHandler;
import org.opendaylight.yangtools.util.concurrent.ThreadFactoryProvider;
import org.opendaylight.yangtools.util.concurrent.TrackingLinkedBlockingQueue;
import org.slf4j.LoggerFactory;

public class FastThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final long DEFAULT_IDLE_TIMEOUT_IN_SEC = 15L;
    private final String threadPrefix;
    private final int maximumQueueSize;

    public FastThreadPoolExecutor(int maximumPoolSize, int maximumQueueSize, String threadPrefix, Class<?> loggerIdentity) {
        this(maximumPoolSize, maximumQueueSize, 15L, TimeUnit.SECONDS, threadPrefix, loggerIdentity);
    }

    public FastThreadPoolExecutor(int maximumPoolSize, int maximumQueueSize, long keepAliveTime, TimeUnit unit, String threadPrefix, Class<?> loggerIdentity) {
        super(maximumPoolSize, maximumPoolSize, keepAliveTime, unit, new TrackingLinkedBlockingQueue<Runnable>(maximumQueueSize));
        this.threadPrefix = threadPrefix;
        this.maximumQueueSize = maximumQueueSize;
        this.setThreadFactory(ThreadFactoryProvider.builder().namePrefix(threadPrefix).logger(LoggerFactory.getLogger(loggerIdentity)).build().get());
        if (keepAliveTime > 0L) {
            this.allowCoreThreadTimeOut(true);
        }
        this.setRejectedExecutionHandler(CountingRejectedExecutionHandler.newAbortPolicy());
    }

    public long getLargestQueueSize() {
        return ((TrackingLinkedBlockingQueue)this.getQueue()).getLargestQueueSize();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper;
    }

    @Override
    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this).add("Thread Prefix", this.threadPrefix).add("Current Thread Pool Size", this.getPoolSize()).add("Largest Thread Pool Size", this.getLargestPoolSize()).add("Max Thread Pool Size", this.getMaximumPoolSize()).add("Current Queue Size", this.getQueue().size()).add("Largest Queue Size", this.getLargestQueueSize()).add("Max Queue Size", this.maximumQueueSize).add("Active Thread Count", this.getActiveCount()).add("Completed Task Count", this.getCompletedTaskCount()).add("Total Task Count", this.getTaskCount())).toString();
    }
}

