/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.opendaylight.yangtools.util.concurrent.ExceptionMapper;

public final class ReflectiveExceptionMapper<X extends Exception>
extends ExceptionMapper<X> {
    private final Constructor<X> ctor;

    private ReflectiveExceptionMapper(String opName, Constructor<X> ctor) {
        super(opName, ctor.getDeclaringClass());
        this.ctor = ctor;
    }

    @Override
    protected X newWithCause(String message, Throwable cause) {
        try {
            return (X)((Exception)this.ctor.newInstance(message, cause));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate exception " + this.ctor.getDeclaringClass(), e);
        }
    }

    public static <X extends Exception> ReflectiveExceptionMapper<X> create(String opName, Class<X> exceptionType) {
        Constructor<X> c;
        try {
            c = exceptionType.getConstructor(String.class, Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class does not define a String, Throwable constructor", e);
        }
        try {
            c.newInstance(opName, new Throwable());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Constructor " + c.getName() + " failed to pass instantiation test", e);
        }
        return new ReflectiveExceptionMapper<X>(opName, c);
    }
}

