/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.RegexPatterns;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class CodeHelpers {
    private CodeHelpers() {
    }

    public static void validValue(boolean expression, Object value, String options) {
        Preconditions.checkArgument(expression, "expected one of: %s \n%but was: %s", (Object)options, value);
    }

    public static <T> @NonNull T nonNullValue(@Nullable T value, @NonNull String name) {
        Objects.requireNonNull(name);
        Preconditions.checkArgument(value != null, "%s must not be null", (Object)name);
        return value;
    }

    public static void requireValue(@Nullable Object value) {
        Objects.requireNonNull(value, "Supplied value may not be null");
    }

    public static void appendValue(MoreObjects.ToStringHelper helper, @NonNull String name, @Nullable Object value) {
        if (value != null) {
            helper.add(name, value);
        }
    }

    public static void appendValue(MoreObjects.ToStringHelper helper, String name, byte[] value) {
        if (value != null) {
            helper.add(name, Arrays.toString(value));
        }
    }

    public static Pattern @NonNull [] compilePatterns(@NonNull List<String> patterns) {
        int size = patterns.size();
        Verify.verify(size > 1, "Patterns has to have at least 2 elements", new Object[0]);
        Pattern[] result = new Pattern[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Pattern.compile(patterns.get(i));
        }
        return result;
    }

    public static void checkPattern(String value, Pattern pattern, String regex) {
        if (!pattern.matcher(value).matches()) {
            String match = RegexPatterns.isNegatedPattern(pattern) ? "matches forbidden" : "does not match required";
            throw new IllegalArgumentException("Supplied value \"" + value + "\" " + match + " pattern \"" + regex + "\"");
        }
    }

    public static void checkPattern(String value, Pattern[] patterns, String[] regexes) {
        Verify.verify(patterns.length == regexes.length, "Patterns and regular expression lengths have to match", new Object[0]);
        for (int i = 0; i < patterns.length; ++i) {
            CodeHelpers.checkPattern(value, patterns[i], regexes[i]);
        }
    }

    public static void throwInvalidLength(String expected, Object actual) {
        throw new IllegalArgumentException("Invalid length: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidLength(String expected, byte[] actual) {
        CodeHelpers.throwInvalidLength(expected, Arrays.toString(actual));
    }

    public static void throwInvalidRange(String expected, Object actual) {
        throw new IllegalArgumentException("Invalid range: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidRange(String expected, int actual) {
        throw new IllegalArgumentException("Invalid range: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidRange(String expected, long actual) {
        throw new IllegalArgumentException("Invalid range: " + actual + ", expected: " + expected + ".");
    }

    public static void throwInvalidRange(Object[] expected, Object actual) {
        CodeHelpers.throwInvalidRange(Arrays.toString(expected), actual);
    }

    public static void throwInvalidRangeUnsigned(String expected, long actual) {
        throw new IllegalArgumentException("Invalid range: " + Long.toUnsignedString(actual) + ", expected: " + expected + ".");
    }

    public static <T> @NonNull List<T> nonnull(@Nullable List<T> input) {
        return input != null ? input : ImmutableList.of();
    }

    public static int wrapperHashCode(@Nullable Object obj) {
        return CodeHelpers.wrapHashCode(Objects.hashCode(obj));
    }

    public static int wrapperHashCode(byte @Nullable [] obj) {
        return CodeHelpers.wrapHashCode(Arrays.hashCode(obj));
    }

    @Deprecated
    public static @Nullable Uint8 compatUint(@Nullable Short value) {
        return value == null ? null : Uint8.valueOf(value);
    }

    @Deprecated
    public static @Nullable Uint16 compatUint(@Nullable Integer value) {
        return value == null ? null : Uint16.valueOf(value);
    }

    @Deprecated
    public static @Nullable Uint32 compatUint(@Nullable Long value) {
        return value == null ? null : Uint32.valueOf(value);
    }

    @Deprecated
    public static @Nullable Uint64 compatUint(@Nullable BigInteger value) {
        return value == null ? null : Uint64.valueOf(value);
    }

    private static int wrapHashCode(int hash) {
        return hash == 0 ? 31 : hash;
    }
}

