/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class InstanceIdentifierBuilderImpl<T extends DataObject>
implements InstanceIdentifier.InstanceIdentifierBuilder<T> {
    private final ImmutableList.Builder<InstanceIdentifier.PathArgument> pathBuilder = ImmutableList.builder();
    private final HashCodeBuilder<InstanceIdentifier.PathArgument> hashBuilder;
    private final Iterable<? extends InstanceIdentifier.PathArgument> basePath;
    private boolean wildcard = false;
    private InstanceIdentifier.PathArgument arg = null;

    InstanceIdentifierBuilderImpl() {
        this.hashBuilder = new HashCodeBuilder();
        this.basePath = null;
    }

    InstanceIdentifierBuilderImpl(InstanceIdentifier.PathArgument item, Iterable<? extends InstanceIdentifier.PathArgument> pathArguments, int hash, boolean wildcard) {
        this.hashBuilder = new HashCodeBuilder(hash);
        this.basePath = pathArguments;
        this.wildcard = wildcard;
        this.arg = item;
    }

    public int hashCode() {
        return this.hashBuilder.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InstanceIdentifierBuilderImpl) {
            InstanceIdentifierBuilderImpl otherBuilder = (InstanceIdentifierBuilderImpl)obj;
            return this.wildcard == otherBuilder.wildcard && Objects.equals(this.basePath, otherBuilder.basePath) && Objects.equals(this.arg, otherBuilder.arg) && Objects.equals(this.hashBuilder.build(), otherBuilder.hashBuilder.build());
        }
        return false;
    }

    @Override
    public <N extends ChildOf<? super T>> InstanceIdentifierBuilderImpl<N> child(Class<N> container) {
        return this.addNode(container);
    }

    @Override
    public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> InstanceIdentifier.InstanceIdentifierBuilder<N> child(Class<C> caze, Class<N> container) {
        return this.addWildNode(InstanceIdentifier.Item.of(caze, container));
    }

    @Override
    public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> InstanceIdentifierBuilderImpl<N> child(Class<N> listItem, K listKey) {
        return this.addNode(InstanceIdentifier.IdentifiableItem.of(listItem, listKey));
    }

    @Override
    public <C extends ChoiceIn<? super T> & DataObject, K extends Identifier<N>, N extends Identifiable<K> & ChildOf<? super C>> InstanceIdentifier.InstanceIdentifierBuilder<N> child(Class<C> caze, Class<N> listItem, K listKey) {
        return this.addNode(InstanceIdentifier.IdentifiableItem.of(caze, listItem, listKey));
    }

    @Override
    public <N extends DataObject & Augmentation<? super T>> InstanceIdentifierBuilderImpl<N> augmentation(Class<N> container) {
        return this.addNode(container);
    }

    @Override
    public InstanceIdentifier<T> build() {
        Preconditions.checkState(this.arg != null, "No path arguments present");
        Iterable<Object> pathArguments = this.basePath == null ? this.pathBuilder.build() : Iterables.concat(this.basePath, this.pathBuilder.build());
        return InstanceIdentifier.trustedCreate(this.arg, pathArguments, this.hashBuilder.build(), this.wildcard);
    }

    <N extends DataObject> @NonNull InstanceIdentifierBuilderImpl<N> addWildNode(InstanceIdentifier.PathArgument newArg) {
        if (Identifiable.class.isAssignableFrom(newArg.getType())) {
            this.wildcard = true;
        }
        return this.addNode(newArg);
    }

    <N extends DataObject> @NonNull InstanceIdentifierBuilderImpl<N> addNode(InstanceIdentifier.PathArgument newArg) {
        this.arg = newArg;
        this.hashBuilder.addArgument(newArg);
        this.pathBuilder.add((Object)newArg);
        return this;
    }

    private <N extends DataObject> @NonNull InstanceIdentifierBuilderImpl<N> addNode(Class<N> container) {
        return this.addWildNode(InstanceIdentifier.Item.of(container));
    }
}

