/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueImplementationValidator;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;

@Beta
@NonNullByDefault
public abstract class AbstractCanonicalValueSupport<T extends CanonicalValue<T>>
implements CanonicalValueSupport<T> {
    private static final ClassValue<Boolean> SUPPORTS = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(@Nullable Class<?> type) {
            Preconditions.checkArgument(CanonicalValueSupport.class.isAssignableFrom(type), "%s is not a CanonicalValueSupport", type);
            int modifiers = type.getModifiers();
            Preconditions.checkArgument(Modifier.isFinal(modifiers), "%s must be final", type);
            return Boolean.TRUE;
        }
    };
    private static final ClassValue<Boolean> VALUES = new AbstractCanonicalValueImplementationValidator(){

        @Override
        void checkCompareTo(@NonNull Class<?> type) {
            2.checkFinalMethod(type, "compareTo", type);
        }
    };
    private final Class<T> representationClass;

    protected AbstractCanonicalValueSupport(Class<T> representationClass) {
        VALUES.get(representationClass);
        this.representationClass = representationClass;
        SUPPORTS.get(this.getClass());
    }

    @Override
    public final Class<T> getRepresentationClass() {
        return this.representationClass;
    }

    @Override
    public final Class<T> getValidatedRepresentationClass() {
        return this.representationClass;
    }

    @Override
    public final Variant<T, CanonicalValueViolation> validateRepresentation(T value) {
        return Variant.ofFirst(value);
    }

    @Override
    public final Variant<T, CanonicalValueViolation> validateRepresentation(T value, String canonicalString) {
        return Variant.ofFirst(value);
    }
}

