/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

@Beta
public interface YangNamespaceContext
extends Immutable,
Serializable {
    public @NonNull Optional<QNameModule> findNamespaceForPrefix(String var1);

    public @NonNull Optional<String> findPrefixForNamespace(QNameModule var1);

    default public @NonNull QName createQName(String prefix, String localName) {
        Optional<QNameModule> namespace = this.findNamespaceForPrefix(prefix);
        Preconditions.checkArgument(namespace.isPresent(), "Prefix %s is not bound", (Object)prefix);
        return QName.create(namespace.get(), localName);
    }
}

