/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common.netty;

import com.google.common.annotations.Beta;
import io.netty.buffer.ByteBuf;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

@Beta
public final class ByteBufUtils {
    private ByteBufUtils() {
    }

    public static @NonNull Uint8 readUint8(ByteBuf buf) {
        return Uint8.fromByteBits(buf.readByte());
    }

    public static @NonNull Uint16 readUint16(ByteBuf buf) {
        return Uint16.fromShortBits(buf.readShort());
    }

    public static @NonNull Uint32 readUint32(ByteBuf buf) {
        return Uint32.fromIntBits(buf.readInt());
    }

    public static @NonNull Uint64 readUint64(ByteBuf buf) {
        return Uint64.fromLongBits(buf.readLong());
    }

    public static void write(ByteBuf buf, Uint8 value) {
        buf.writeByte(value.byteValue());
    }

    public static void write(ByteBuf buf, Uint16 value) {
        buf.writeShort(value.shortValue());
    }

    public static void write(ByteBuf buf, Uint32 value) {
        buf.writeInt(value.intValue());
    }

    public static void write(ByteBuf buf, Uint64 value) {
        buf.writeLong(value.longValue());
    }

    public static void writeMandatory(ByteBuf buf, Byte value, String name) {
        buf.writeByte(ByteBufUtils.nonNullArgument(value, name).byteValue());
    }

    public static void writeMandatory(ByteBuf buf, Short value, String name) {
        buf.writeShort(ByteBufUtils.nonNullArgument(value, name).shortValue());
    }

    public static void writeMandatory(ByteBuf buf, Integer value, String name) {
        buf.writeInt(ByteBufUtils.nonNullArgument(value, name));
    }

    public static void writeMandatory(ByteBuf buf, Long value, String name) {
        buf.writeLong(ByteBufUtils.nonNullArgument(value, name));
    }

    public static void writeMandatory(ByteBuf buf, Uint8 value, String name) {
        ByteBufUtils.write(buf, ByteBufUtils.nonNullArgument(value, name));
    }

    public static void writeMandatory(ByteBuf buf, Uint16 value, String name) {
        ByteBufUtils.write(buf, ByteBufUtils.nonNullArgument(value, name));
    }

    public static void writeMandatory(ByteBuf buf, Uint32 value, String name) {
        ByteBufUtils.write(buf, ByteBufUtils.nonNullArgument(value, name));
    }

    public static void writeMandatory(ByteBuf buf, Uint64 value, String name) {
        ByteBufUtils.write(buf, ByteBufUtils.nonNullArgument(value, name));
    }

    public static void writeOptional(ByteBuf buf, @Nullable Byte value) {
        if (value != null) {
            buf.writeByte(value.byteValue());
        }
    }

    public static void writeOptional(ByteBuf buf, @Nullable Short value) {
        if (value != null) {
            buf.writeShort(value.shortValue());
        }
    }

    public static void writeOptional(ByteBuf buf, @Nullable Integer value) {
        if (value != null) {
            buf.writeInt(value);
        }
    }

    public static void writeOptional(ByteBuf buf, @Nullable Long value) {
        if (value != null) {
            buf.writeLong(value);
        }
    }

    public static void writeOptional(ByteBuf buf, @Nullable Uint8 value) {
        if (value != null) {
            ByteBufUtils.write(buf, value);
        }
    }

    public static void writeOptional(ByteBuf buf, @Nullable Uint16 value) {
        if (value != null) {
            ByteBufUtils.write(buf, value);
        }
    }

    public static void writeOptional(ByteBuf buf, @Nullable Uint32 value) {
        if (value != null) {
            ByteBufUtils.write(buf, value);
        }
    }

    public static void writeOptional(ByteBuf buf, @Nullable Uint64 value) {
        if (value != null) {
            ByteBufUtils.write(buf, value);
        }
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Byte value) {
        buf.writeByte(value != null ? value : (byte)0);
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Short value) {
        buf.writeShort(value != null ? value : (short)0);
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Integer value) {
        buf.writeInt(value != null ? value : 0);
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Long value) {
        buf.writeLong(value != null ? value : 0L);
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Uint8 value) {
        buf.writeByte(value != null ? value.byteValue() : (byte)0);
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Uint16 value) {
        buf.writeShort(value != null ? value.shortValue() : (short)0);
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Uint32 value) {
        buf.writeInt(value != null ? value.intValue() : 0);
    }

    public static void writeOrZero(ByteBuf buf, @Nullable Uint64 value) {
        buf.writeLong(value != null ? value.longValue() : 0L);
    }

    private static <T> @NonNull T nonNullArgument(@Nullable T obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " is mandatory");
        }
        return obj;
    }
}

