/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.collect.ImmutableMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class NIPv2
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private YangInstanceIdentifier.NodeIdentifierWithPredicates nip;

    public NIPv2() {
    }

    NIPv2(YangInstanceIdentifier.NodeIdentifierWithPredicates nid) {
        this.nip = Objects.requireNonNull(nid);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.nip.getNodeType().writeTo(out);
        out.writeInt(this.nip.size());
        for (Map.Entry<QName, Object> entry : this.nip.entrySet()) {
            entry.getKey().writeTo(out);
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        QName qname = QName.readFrom(in);
        int size = in.readInt();
        switch (size) {
            case 0: {
                this.nip = YangInstanceIdentifier.NodeIdentifierWithPredicates.of(qname);
                break;
            }
            case 1: {
                this.nip = YangInstanceIdentifier.NodeIdentifierWithPredicates.of(qname, QName.readFrom(in), in.readObject());
                break;
            }
            default: {
                ImmutableMap.Builder<QName, Object> keys = ImmutableMap.builderWithExpectedSize(size);
                for (int i = 0; i < size; ++i) {
                    keys.put(QName.readFrom(in), in.readObject());
                }
                this.nip = YangInstanceIdentifier.NodeIdentifierWithPredicates.of(qname, keys.build());
            }
        }
    }

    private Object readResolve() {
        return this.nip;
    }
}

