/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class YIDv1
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private YangInstanceIdentifier yid;

    public YIDv1() {
    }

    YIDv1(YangInstanceIdentifier yid) {
        this.yid = Objects.requireNonNull(yid);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        List<YangInstanceIdentifier.PathArgument> args = this.yid.getPathArguments();
        out.writeInt(args.size());
        for (YangInstanceIdentifier.PathArgument arg : args) {
            out.writeObject(arg);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            builder.add((YangInstanceIdentifier.PathArgument)in.readObject());
        }
        this.yid = YangInstanceIdentifier.create(builder.build());
    }

    private Object readResolve() {
        return this.yid;
    }
}

