/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DeleteLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.EmptyDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.NormalizedNodeDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.RecursiveDeleteCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.RecursiveReplaceCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.RecursiveUnmodifiedCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.RecursiveWriteCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReplaceLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.UnmodifiedLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.WriteLeafCandidateNode;

@Beta
public final class DataTreeCandidateNodes {
    private DataTreeCandidateNodes() {
    }

    public static @NonNull DataTreeCandidateNode empty(YangInstanceIdentifier.PathArgument identifier) {
        return new EmptyDataTreeCandidateNode(identifier);
    }

    public static @NonNull DataTreeCandidateNode unmodified(NormalizedNode<?, ?> node) {
        if (node instanceof NormalizedNodeContainer) {
            return new RecursiveUnmodifiedCandidateNode((NormalizedNodeContainer)node);
        }
        return new UnmodifiedLeafCandidateNode(node);
    }

    public static @NonNull DataTreeCandidateNode written(NormalizedNode<?, ?> node) {
        return new NormalizedNodeDataTreeCandidateNode(node);
    }

    public static @NonNull Collection<DataTreeCandidateNode> containerDelta(@Nullable NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData, @Nullable NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> newData) {
        NormalizedNode child;
        if (newData == null) {
            return oldData == null ? ImmutableList.of() : Collections2.transform(oldData.getValue(), DataTreeCandidateNodes::deleteNode);
        }
        if (oldData == null) {
            return Collections2.transform(newData.getValue(), DataTreeCandidateNodes::writeNode);
        }
        ArrayList<DataTreeCandidateNode> result = new ArrayList<DataTreeCandidateNode>();
        Iterator iterator = newData.getValue().iterator();
        while (iterator.hasNext()) {
            child = (NormalizedNode)iterator.next();
            Optional<NormalizedNode<?, ?>> maybeOldChild = oldData.getChild((YangInstanceIdentifier.PathArgument)child.getIdentifier());
            DataTreeCandidateNode node = maybeOldChild.isPresent() ? DataTreeCandidateNodes.replaceNode(maybeOldChild.get(), child) : DataTreeCandidateNodes.writeNode(child);
            result.add(node);
        }
        iterator = oldData.getValue().iterator();
        while (iterator.hasNext()) {
            child = (NormalizedNode)iterator.next();
            if (!newData.getChild((YangInstanceIdentifier.PathArgument)child.getIdentifier()).isEmpty()) continue;
            result.add(DataTreeCandidateNodes.deleteNode(child));
        }
        return result;
    }

    public static @NonNull Optional<DataTreeCandidateNode> containerDelta(@Nullable NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> oldData, @Nullable NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> newData, @NonNull YangInstanceIdentifier.PathArgument child) {
        Optional<NormalizedNode<?, ?>> maybeNewChild = DataTreeCandidateNodes.getChild(newData, child);
        Optional<NormalizedNode<?, ?>> maybeOldChild = DataTreeCandidateNodes.getChild(oldData, child);
        if (maybeOldChild.isPresent()) {
            NormalizedNode<?, ?> oldChild = maybeOldChild.get();
            return Optional.of(maybeNewChild.isPresent() ? DataTreeCandidateNodes.replaceNode(oldChild, maybeNewChild.get()) : DataTreeCandidateNodes.deleteNode(oldChild));
        }
        return maybeNewChild.map(DataTreeCandidateNodes::writeNode);
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        switch (node.getModificationType()) {
            case DELETE: {
                cursor.delete(node.getIdentifier());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(node.getIdentifier());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.getChildNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(node.getIdentifier(), node.getDataAfter().get());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.getModificationType());
            }
        }
    }

    public static void applyRootedNodeToCursor(DataTreeModificationCursor cursor, YangInstanceIdentifier rootPath, DataTreeCandidateNode node) {
        switch (node.getModificationType()) {
            case DELETE: {
                cursor.delete(rootPath.getLastPathArgument());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(rootPath.getLastPathArgument());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.getChildNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(rootPath.getLastPathArgument(), node.getDataAfter().get());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.getModificationType());
            }
        }
    }

    public static void applyRootToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        switch (node.getModificationType()) {
            case DELETE: {
                throw new IllegalArgumentException("Can not delete root.");
            }
            case SUBTREE_MODIFIED: 
            case WRITE: {
                AbstractNodeIterator iterator = new RootNonExitingIterator(node.getChildNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.getModificationType());
            }
        }
    }

    private static Optional<NormalizedNode<?, ?>> getChild(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> container, YangInstanceIdentifier.PathArgument identifier) {
        return container == null ? Optional.empty() : container.getChild(identifier);
    }

    private static @NonNull DataTreeCandidateNode deleteNode(NormalizedNode<?, ?> data) {
        if (data instanceof NormalizedNodeContainer) {
            return new RecursiveDeleteCandidateNode((NormalizedNodeContainer)data);
        }
        return new DeleteLeafCandidateNode(data);
    }

    private static @NonNull DataTreeCandidateNode replaceNode(NormalizedNode<?, ?> oldData, NormalizedNode<?, ?> newData) {
        if (oldData instanceof NormalizedNodeContainer) {
            return new RecursiveReplaceCandidateNode((NormalizedNodeContainer)oldData, (NormalizedNodeContainer)newData);
        }
        return new ReplaceLeafCandidateNode(oldData, newData);
    }

    private static @NonNull DataTreeCandidateNode writeNode(NormalizedNode<?, ?> data) {
        if (data instanceof NormalizedNodeContainer) {
            return new RecursiveWriteCandidateNode((NormalizedNodeContainer)data);
        }
        return new WriteLeafCandidateNode(data);
    }

    private static final class ExitingNodeIterator
    extends AbstractNodeIterator {
        private final AbstractNodeIterator parent;

        ExitingNodeIterator(AbstractNodeIterator parent, Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        AbstractNodeIterator getParent() {
            return this.parent;
        }

        @Override
        void exitNode(DataTreeModificationCursor cursor) {
            cursor.exit();
        }
    }

    private static final class RootNonExitingIterator
    extends AbstractNodeIterator {
        RootNonExitingIterator(Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
        }

        @Override
        void exitNode(DataTreeModificationCursor cursor) {
        }

        @Override
        AbstractNodeIterator getParent() {
            return null;
        }
    }

    private static abstract class AbstractNodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;

        AbstractNodeIterator(Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        final AbstractNodeIterator next(DataTreeModificationCursor cursor) {
            block6: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                switch (node.getModificationType()) {
                    case DELETE: {
                        cursor.delete(node.getIdentifier());
                        continue block6;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case DISAPPEARED: {
                        Collection<DataTreeCandidateNode> children = node.getChildNodes();
                        if (children.isEmpty()) continue block6;
                        cursor.enter(node.getIdentifier());
                        return new ExitingNodeIterator(this, children.iterator());
                    }
                    case UNMODIFIED: {
                        continue block6;
                    }
                    case WRITE: {
                        cursor.write(node.getIdentifier(), node.getDataAfter().get());
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported modification " + node.getModificationType());
            }
            this.exitNode(cursor);
            return this.getParent();
        }

        abstract @Nullable AbstractNodeIterator getParent();

        abstract void exitNode(DataTreeModificationCursor var1);
    }
}

