/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;

@Beta
public final class StoreTreeNodes {
    private StoreTreeNodes() {
    }

    public static <T extends StoreTreeNode<T>> Optional<? extends T> findNode(T tree, YangInstanceIdentifier path) {
        Optional<T> current = Optional.of(tree);
        Iterator<YangInstanceIdentifier.PathArgument> pathIter = path.getPathArguments().iterator();
        while (current.isPresent() && pathIter.hasNext()) {
            current = current.get().getChild(pathIter.next());
        }
        return current;
    }

    public static <T extends StoreTreeNode<T>> T findNodeChecked(T tree, YangInstanceIdentifier path) {
        Object current = tree;
        int depth = 1;
        for (YangInstanceIdentifier.PathArgument pathArg : path.getPathArguments()) {
            Optional<T> potential = current.getChild(pathArg);
            if (potential.isEmpty()) {
                throw new IllegalArgumentException(String.format("Child %s is not present in tree.", path.getAncestor(depth)));
            }
            current = (StoreTreeNode)potential.get();
            ++depth;
        }
        return current;
    }

    public static <T extends StoreTreeNode<T>> Map.Entry<YangInstanceIdentifier, T> findClosest(T tree, YangInstanceIdentifier path) {
        return StoreTreeNodes.findClosestsOrFirstMatch(tree, path, input -> false);
    }

    public static <T extends StoreTreeNode<T>> Map.Entry<YangInstanceIdentifier, T> findClosestsOrFirstMatch(T tree, YangInstanceIdentifier path, Predicate<T> predicate) {
        Optional<T> parent = Optional.of(tree);
        Optional<T> current = Optional.of(tree);
        int nesting = 0;
        Iterator<YangInstanceIdentifier.PathArgument> pathIter = path.getPathArguments().iterator();
        while (current.isPresent() && pathIter.hasNext() && !predicate.test(current.get())) {
            parent = current;
            current = current.get().getChild(pathIter.next());
            ++nesting;
        }
        if (current.isPresent()) {
            YangInstanceIdentifier currentPath = path.getAncestor(nesting);
            return new AbstractMap.SimpleImmutableEntry<YangInstanceIdentifier, T>(currentPath, current.get());
        }
        Verify.verify(nesting > 0);
        return new AbstractMap.SimpleImmutableEntry<YangInstanceIdentifier, T>(path.getAncestor(nesting - 1), parent.get());
    }

    public static <T extends StoreTreeNode<T>> Optional<? extends T> getChild(Optional<T> parent, YangInstanceIdentifier.PathArgument child) {
        if (parent.isPresent()) {
            return ((StoreTreeNode)parent.get()).getChild(child);
        }
        return Optional.empty();
    }
}

