/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree.spi;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Collections2;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.AbstractModifiedContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.LazyMutableContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.MaterializedMutableContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;

final class LazyContainerNode
extends AbstractModifiedContainerNode {
    LazyContainerNode(NormalizedNode<?, ?> data, Version version, Version subtreeVersion) {
        this(data, version, MapAdaptor.getDefaultInstance().initialSnapshot(1), subtreeVersion);
    }

    LazyContainerNode(NormalizedNode<?, ?> data, Version version, Map<YangInstanceIdentifier.PathArgument, TreeNode> children, Version subtreeVersion) {
        super(data, version, children, subtreeVersion);
    }

    @Override
    public MutableTreeNode mutable() {
        Map<YangInstanceIdentifier.PathArgument, TreeNode> snapshot = this.snapshotChildren();
        if (snapshot.size() == this.castData().getValue().size()) {
            return new MaterializedMutableContainerNode(this, snapshot);
        }
        return new LazyMutableContainerNode(this, snapshot);
    }

    @Override
    public Optional<TreeNode> getChild(YangInstanceIdentifier.PathArgument childId) {
        TreeNode modified = this.getModifiedChild(childId);
        return modified == null ? this.getChildFromData(childId) : Optional.of(modified);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("untouched", Collections2.filter(this.castData().getValue(), input -> this.getModifiedChild((YangInstanceIdentifier.PathArgument)input.getIdentifier()) == null));
    }
}

