/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;

@Beta
@NonNullByDefault
public interface PathExpression
extends Immutable {
    public String getOriginalString();

    public Steps getSteps();

    default public boolean isAbsolute() {
        Steps steps = this.getSteps();
        return steps instanceof LocationPathSteps && ((LocationPathSteps)steps).getLocationPath().isAbsolute();
    }

    public static final class DerefSteps
    extends Steps {
        private final YangLocationPath.Relative derefArgument;
        private final YangLocationPath.Relative relativePath;

        public DerefSteps(YangLocationPath.Relative derefArgument, YangLocationPath.Relative relativePath) {
            this.derefArgument = Objects.requireNonNull(derefArgument);
            this.relativePath = Objects.requireNonNull(relativePath);
        }

        public YangLocationPath.Relative getDerefArgument() {
            return this.derefArgument;
        }

        public YangLocationPath.Relative getRelativePath() {
            return this.relativePath;
        }

        @Override
        public int hashCode() {
            return 31 * this.derefArgument.hashCode() + this.relativePath.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DerefSteps)) {
                return false;
            }
            DerefSteps other = (DerefSteps)obj;
            return this.derefArgument.equals(other.derefArgument) && this.relativePath.equals(other.relativePath);
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("derefArgument", this.derefArgument).add("relativePath", this.relativePath);
        }
    }

    public static final class LocationPathSteps
    extends Steps {
        private final YangLocationPath locationPath;

        public LocationPathSteps(YangLocationPath locationPath) {
            this.locationPath = Objects.requireNonNull(locationPath);
        }

        public YangLocationPath getLocationPath() {
            return this.locationPath;
        }

        @Override
        public int hashCode() {
            return this.locationPath.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof LocationPathSteps && this.locationPath.equals(((LocationPathSteps)obj).locationPath);
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("locationPath", this.locationPath);
        }
    }

    public static abstract class Steps {
        Steps() {
        }

        public abstract int hashCode();

        public abstract boolean equals(@Nullable Object var1);

        public final String toString() {
            return this.addToStringAttributes(MoreObjects.toStringHelper(this)).toString();
        }

        abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);
    }
}

