/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.AbstractStatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;

@Beta
@NonNullByDefault
public final class DefaultStatementDefinition<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends AbstractStatementDefinition {
    private final Class<E> effectiveRepresentation;
    private final Class<D> declaredRepresentation;

    DefaultStatementDefinition(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation, boolean argumentYinElement, @Nullable QName argumentName) {
        super(statementName, argumentYinElement, argumentName);
        this.declaredRepresentation = Objects.requireNonNull(declaredRepresentation);
        this.effectiveRepresentation = Objects.requireNonNull(effectiveRepresentation);
        Preconditions.checkArgument(declaredRepresentation.isInterface(), "Declared representation %s is not an interface", declaredRepresentation);
        Preconditions.checkArgument(effectiveRepresentation.isInterface(), "Effective representation %s is not an interface", effectiveRepresentation);
    }

    public static <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> DefaultStatementDefinition<A, D, E> of(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation) {
        return new DefaultStatementDefinition<A, D, E>(statementName, declaredRepresentation, effectiveRepresentation, false, null);
    }

    public static <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> DefaultStatementDefinition<A, D, E> of(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation, QName argumentName) {
        return DefaultStatementDefinition.of(statementName, declaredRepresentation, effectiveRepresentation, argumentName, false);
    }

    public static <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> DefaultStatementDefinition<A, D, E> of(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation, QName argumentName, boolean argumentYinElement) {
        return new DefaultStatementDefinition<A, D, E>(statementName, declaredRepresentation, effectiveRepresentation, argumentYinElement, Objects.requireNonNull(argumentName));
    }

    @Override
    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.declaredRepresentation;
    }

    @Override
    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        return this.effectiveRepresentation;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("declared", this.declaredRepresentation).add("effective", this.effectiveRepresentation);
    }
}

