/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

final class YangTextFileSchemaSource
extends YangTextSchemaSource
implements Delegator<File> {
    private final @NonNull File file;

    YangTextFileSchemaSource(SourceIdentifier identifier, File file) {
        super(identifier);
        this.file = Objects.requireNonNull(file);
    }

    @Override
    public File getDelegate() {
        return this.file;
    }

    @Override
    public InputStream openStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("file", this.file);
    }

    @Override
    public Optional<String> getSymbolicName() {
        return Optional.of(this.file.toString());
    }
}

