/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YinXmlSchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class YinDomSchemaSource
implements YinXmlSchemaSource {
    private static final Logger LOG = LoggerFactory.getLogger(YinDomSchemaSource.class);
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final QName REVISION_STMT = YangStmtMapping.REVISION.getStatementName();
    private static final String MODULE_ARG = YangStmtMapping.MODULE.getArgumentDefinition().get().getArgumentName().getLocalName();
    private static final String REVISION_ARG = YangStmtMapping.REVISION.getArgumentDefinition().get().getArgumentName().getLocalName();

    YinDomSchemaSource() {
    }

    public static @NonNull YinDomSchemaSource create(@NonNull SourceIdentifier identifier, @NonNull DOMSource source) {
        SourceIdentifier id;
        Node root = source.getNode().getFirstChild();
        String rootNs = root.getNamespaceURI();
        if (rootNs == null) {
            return new Simple(identifier, source);
        }
        QName qname = QName.create(rootNs, root.getLocalName());
        Preconditions.checkArgument(YangConstants.RFC6020_YIN_MODULE.equals(qname.getModule()), "Root node namepsace %s does not match %s", (Object)rootNs, (Object)YangConstants.RFC6020_YIN_NAMESPACE);
        Preconditions.checkArgument(YangStmtMapping.MODULE.getStatementName().equals(qname) || YangStmtMapping.SUBMODULE.getStatementName().equals(qname), "Root element %s is not a module nor a submodule", (Object)qname);
        Preconditions.checkArgument(root instanceof Element, "Root node %s is not an element", (Object)root);
        Element element = (Element)root;
        Attr nameAttr = element.getAttributeNode(MODULE_ARG);
        Preconditions.checkArgument(nameAttr != null, "No %s name argument found in %s", (Object)element.getLocalName());
        NodeList revisions = element.getElementsByTagNameNS(REVISION_STMT.getNamespace().toString(), REVISION_STMT.getLocalName());
        if (revisions.getLength() == 0) {
            return new Simple(identifier, source);
        }
        Element revisionStmt = (Element)revisions.item(0);
        Attr dateAttr = revisionStmt.getAttributeNode(REVISION_ARG);
        Preconditions.checkArgument(dateAttr != null, "No revision statement argument found in %s", (Object)revisionStmt);
        RevisionSourceIdentifier parsedId = RevisionSourceIdentifier.create(nameAttr.getValue(), Revision.of(dateAttr.getValue()));
        if (!((Object)parsedId).equals(identifier)) {
            LOG.debug("Changed identifier from {} to {}", (Object)identifier, (Object)parsedId);
            id = parsedId;
        } else {
            id = identifier;
        }
        return new Simple(id, source);
    }

    public static @NonNull YinDomSchemaSource lazyTransform(YinXmlSchemaSource xmlSchemaSource) {
        YinDomSchemaSource cast = YinDomSchemaSource.castSchemaSource(xmlSchemaSource);
        return cast != null ? cast : new Transforming(xmlSchemaSource);
    }

    public static @NonNull YinDomSchemaSource transform(YinXmlSchemaSource xmlSchemaSource) throws TransformerException {
        YinDomSchemaSource cast = YinDomSchemaSource.castSchemaSource(xmlSchemaSource);
        return cast != null ? cast : YinDomSchemaSource.create(xmlSchemaSource.getIdentifier(), YinDomSchemaSource.transformSource(xmlSchemaSource.getSource()));
    }

    @Override
    public abstract DOMSource getSource();

    @Override
    public final Class<? extends YinXmlSchemaSource> getType() {
        return YinDomSchemaSource.class;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this).add("identifier", this.getIdentifier())).toString();
    }

    protected abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);

    static @NonNull DOMSource transformSource(Source source) throws TransformerException {
        DOMResult result = new DOMResult();
        TRANSFORMER_FACTORY.newTransformer().transform(source, result);
        return new DOMSource(result.getNode(), result.getSystemId());
    }

    private static @Nullable YinDomSchemaSource castSchemaSource(YinXmlSchemaSource xmlSchemaSource) {
        if (xmlSchemaSource instanceof YinDomSchemaSource) {
            return (YinDomSchemaSource)xmlSchemaSource;
        }
        Source source = xmlSchemaSource.getSource();
        if (source instanceof DOMSource) {
            return YinDomSchemaSource.create(xmlSchemaSource.getIdentifier(), (DOMSource)source);
        }
        return null;
    }

    private static final class Transforming
    extends YinDomSchemaSource {
        private final YinXmlSchemaSource xmlSchemaSource;
        private volatile DOMSource source;

        Transforming(YinXmlSchemaSource xmlSchemaSource) {
            this.xmlSchemaSource = Objects.requireNonNull(xmlSchemaSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DOMSource getSource() {
            DOMSource ret = this.source;
            if (ret == null) {
                Transforming transforming = this;
                synchronized (transforming) {
                    ret = this.source;
                    if (ret == null) {
                        try {
                            ret = Transforming.transformSource(this.xmlSchemaSource.getSource());
                        }
                        catch (TransformerException e) {
                            throw new IllegalStateException("Failed to transform schema source " + this.xmlSchemaSource, e);
                        }
                        this.source = ret;
                    }
                }
            }
            return ret;
        }

        @Override
        public SourceIdentifier getIdentifier() {
            return this.xmlSchemaSource.getIdentifier();
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("xmlSchemaSource", this.xmlSchemaSource);
        }
    }

    private static final class Simple
    extends YinDomSchemaSource {
        private final @NonNull SourceIdentifier identifier;
        private final @NonNull DOMSource source;

        Simple(@NonNull SourceIdentifier identifier, @NonNull DOMSource source) {
            this.identifier = Objects.requireNonNull(identifier);
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public DOMSource getSource() {
            return this.source;
        }

        @Override
        public SourceIdentifier getIdentifier() {
            return this.identifier;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("source", this.source);
        }
    }
}

